/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.datatable.feature;

import java.io.IOException;
import java.util.Map;
import javax.faces.context.FacesContext;
import org.primefaces.component.column.Column;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.component.datatable.DataTableRenderer;
import org.primefaces.component.datatable.feature.DataTableFeature;

public class ResizableColumnsFeature
implements DataTableFeature {
    public void decode(FacesContext context, DataTable table) {
        Map params = FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap();
        String clientId = table.getClientId();
        String columnId = (String)params.get(clientId + "_columnId");
        String width = (String)params.get(clientId + "_width");
        Column column = table.findColumn(columnId);
        column.setWidth(Integer.parseInt(width));
    }

    public void encode(FacesContext context, DataTableRenderer renderer, DataTable table) throws IOException {
        throw new RuntimeException("ResizableColumnsFeature should not encode.");
    }

    public boolean shouldDecode(FacesContext context, DataTable table) {
        return table.isResizableColumns() && this.isResizeRequest(context, table);
    }

    public boolean shouldEncode(FacesContext context, DataTable table) {
        return false;
    }

    private boolean isResizeRequest(FacesContext context, DataTable table) {
        return context.getExternalContext().getRequestParameterMap().containsKey(table.getClientId(context) + "_colResize");
    }
}

