/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.datatable.feature;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UINamingContainer;
import javax.faces.context.FacesContext;
import org.primefaces.component.api.DynamicColumn;
import org.primefaces.component.api.UIColumn;
import org.primefaces.component.column.Column;
import org.primefaces.component.columngroup.ColumnGroup;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.component.datatable.DataTableRenderer;
import org.primefaces.component.datatable.feature.DataTableFeature;
import org.primefaces.component.row.Row;
import org.primefaces.context.RequestContext;
import org.primefaces.model.filter.ContainsFilterConstraint;
import org.primefaces.model.filter.EndsWithFilterConstraint;
import org.primefaces.model.filter.ExactFilterConstraint;
import org.primefaces.model.filter.FilterConstraint;
import org.primefaces.model.filter.StartsWithFilterConstraint;
import org.primefaces.util.ComponentUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterFeature
implements DataTableFeature {
    private static final Logger logger = Logger.getLogger(DataTable.class.getName());
    private static final String STARTS_WITH_MATCH_MODE = "startsWith";
    private static final String ENDS_WITH_MATCH_MODE = "endsWith";
    private static final String CONTAINS_MATCH_MODE = "contains";
    private static final String EXACT_MATCH_MODE = "exact";

    private boolean isFilterRequest(FacesContext context, DataTable table) {
        return context.getExternalContext().getRequestParameterMap().containsKey(table.getClientId(context) + "_filtering");
    }

    @Override
    public boolean shouldDecode(FacesContext context, DataTable table) {
        return this.isFilterRequest(context, table);
    }

    @Override
    public boolean shouldEncode(FacesContext context, DataTable table) {
        return this.isFilterRequest(context, table);
    }

    @Override
    public void decode(FacesContext context, DataTable table) {
        this.updateFilteredValue(context, table, null);
        table.setFirst(0);
        table.setRowIndex(-1);
        String globalFilterParam = table.getClientId(context) + UINamingContainer.getSeparatorChar((FacesContext)context) + "globalFilter";
        Map<String, UIColumn> columnFilterMap = this.populateColumnFilterMap(context, table);
        Map<String, String> filterParameterMap = this.populateFilterParameterMap(context, table, columnFilterMap, globalFilterParam);
        table.setFilters(filterParameterMap);
        if (!table.isLazy()) {
            this.filter(context, table, columnFilterMap, globalFilterParam);
        }
    }

    protected void filter(FacesContext context, DataTable table, Map<String, UIColumn> filterMap, String globalFilterParam) {
        RequestContext requestContext;
        Map params = context.getExternalContext().getRequestParameterMap();
        ArrayList<Object> filteredData = new ArrayList<Object>();
        boolean hasGlobalFilter = params.containsKey(globalFilterParam);
        String globalFilter = hasGlobalFilter ? ((String)params.get(globalFilterParam)).toLowerCase() : null;
        for (int i = 0; i < table.getRowCount(); ++i) {
            table.setRowIndex(i);
            boolean localMatch = true;
            boolean globalMatch = false;
            for (String filterParamName : filterMap.keySet()) {
                String filterParamValue;
                UIColumn column = filterMap.get(filterParamName);
                String string = filterParamValue = params.containsKey(filterParamName) ? ((String)params.get(filterParamName)).toLowerCase() : null;
                if (column instanceof DynamicColumn) {
                    ((DynamicColumn)column).applyModel();
                }
                String columnValue = String.valueOf(column.getValueExpression("filterBy").getValue(context.getELContext()));
                FilterConstraint filterConstraint = this.getFilterConstraint(column);
                if (hasGlobalFilter && !globalMatch && columnValue != null && columnValue.toLowerCase().contains(globalFilter)) {
                    globalMatch = true;
                }
                if (ComponentUtils.isValueBlank(filterParamValue)) {
                    localMatch = true;
                    continue;
                }
                if (columnValue != null && filterConstraint.applies(columnValue.toLowerCase(), filterParamValue)) continue;
                localMatch = false;
                break;
            }
            boolean matches = localMatch;
            if (hasGlobalFilter) {
                boolean bl = matches = localMatch && globalMatch;
            }
            if (!matches) continue;
            filteredData.add(table.getRowData());
        }
        if (table.isPaginator() && (requestContext = RequestContext.getCurrentInstance()) != null) {
            requestContext.addCallbackParam("totalRecords", filteredData.size());
        }
        this.updateFilteredValue(context, table, filteredData);
        table.setRowIndex(-1);
    }

    @Override
    public void encode(FacesContext context, DataTableRenderer renderer, DataTable table) throws IOException {
        if (table.isLazy()) {
            table.loadLazyData();
        }
        renderer.encodeTbody(context, table, true);
    }

    public void updateFilteredValue(FacesContext context, DataTable table, List<?> value) {
        table.setSelectableDataModelWrapper(null);
        ValueExpression ve = table.getValueExpression("filteredValue");
        if (ve != null) {
            ve.setValue(context.getELContext(), value);
        } else {
            if (value != null) {
                logger.log(Level.WARNING, "DataTable {0} has filtering enabled but no filteredValue model reference is defined, for backward compatibility falling back to page viewstate method to keep filteredValue. It is highly suggested to use filtering with a filteredValue model reference as viewstate method is deprecated and will be removed in future.", new Object[]{table.getClientId(context)});
            }
            table.setFilteredValue(value);
        }
    }

    public Map<String, String> populateFilterParameterMap(FacesContext context, DataTable table, Map<String, UIColumn> filterColumnMap, String globalFilterParam) {
        Map params = context.getExternalContext().getRequestParameterMap();
        HashMap<String, String> filterParameterMap = new HashMap<String, String>();
        for (String filterName : filterColumnMap.keySet()) {
            UIColumn column = filterColumnMap.get(filterName);
            String filterValue = (String)params.get(filterName);
            if (ComponentUtils.isValueBlank(filterValue)) continue;
            String filterField = null;
            if (column instanceof DynamicColumn) {
                ((DynamicColumn)column).applyModel();
                filterField = table.resolveDynamicField(column.getValueExpression("filterBy"));
            } else {
                filterField = table.resolveStaticField(column.getValueExpression("filterBy"));
            }
            filterParameterMap.put(filterField, filterValue);
        }
        if (params.containsKey(globalFilterParam)) {
            filterParameterMap.put("globalFilter", (String)params.get(globalFilterParam));
        }
        return filterParameterMap;
    }

    public Map<String, UIColumn> populateColumnFilterMap(FacesContext context, DataTable table) {
        HashMap<String, UIColumn> filterMap = new HashMap<String, UIColumn>();
        String separator = String.valueOf(UINamingContainer.getSeparatorChar((FacesContext)context));
        ColumnGroup group = this.getColumnGroup(table, "header");
        if (group != null) {
            for (UIComponent child : group.getChildren()) {
                Row headerRow = (Row)child;
                if (!headerRow.isRendered()) continue;
                for (UIComponent headerRowChild : headerRow.getChildren()) {
                    Column column = (Column)headerRowChild;
                    if (!column.isRendered() || column.getValueExpression("filterBy") == null) continue;
                    String filterId = column.getClientId(FacesContext.getCurrentInstance()) + separator + "filter";
                    filterMap.put(filterId, column);
                }
            }
        } else {
            for (UIColumn column : table.getColumns()) {
                if (column.getValueExpression("filterBy") == null) continue;
                if (column instanceof Column) {
                    String filterId = column.getClientId(FacesContext.getCurrentInstance()) + separator + "filter";
                    filterMap.put(filterId, column);
                    continue;
                }
                if (!(column instanceof DynamicColumn)) continue;
                DynamicColumn dynamicColumn = (DynamicColumn)column;
                dynamicColumn.applyModel();
                String filterId = dynamicColumn.getContainerClientId(FacesContext.getCurrentInstance()) + separator + "filter";
                filterMap.put(filterId, dynamicColumn);
            }
        }
        return filterMap;
    }

    private ColumnGroup getColumnGroup(DataTable table, String target) {
        for (UIComponent child : table.getChildren()) {
            ColumnGroup colGroup;
            String type;
            if (!(child instanceof ColumnGroup) || (type = (colGroup = (ColumnGroup)child).getType()) == null || !type.equals(target)) continue;
            return colGroup;
        }
        return null;
    }

    public FilterConstraint getFilterConstraint(UIColumn column) {
        String filterMatchMode = column.getFilterMatchMode();
        FilterConstraint filterConstraint = null;
        if (filterMatchMode.equals(STARTS_WITH_MATCH_MODE)) {
            filterConstraint = new StartsWithFilterConstraint();
        } else if (filterMatchMode.equals(ENDS_WITH_MATCH_MODE)) {
            filterConstraint = new EndsWithFilterConstraint();
        } else if (filterMatchMode.equals(CONTAINS_MATCH_MODE)) {
            filterConstraint = new ContainsFilterConstraint();
        } else if (filterMatchMode.equals(EXACT_MATCH_MODE)) {
            filterConstraint = new ExactFilterConstraint();
        } else {
            throw new FacesException("Illegal filter match mode:" + filterMatchMode);
        }
        return filterConstraint;
    }
}

