/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.datatable.feature;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UINamingContainer;
import javax.faces.context.FacesContext;
import org.primefaces.component.api.DynamicColumn;
import org.primefaces.component.api.UIColumn;
import org.primefaces.component.column.Column;
import org.primefaces.component.columns.Columns;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.component.datatable.DataTableRenderer;
import org.primefaces.component.datatable.feature.DataTableFeature;

public class DraggableColumnsFeature
implements DataTableFeature {
    public void decode(FacesContext context, DataTable table) {
        Map params = context.getExternalContext().getRequestParameterMap();
        String[] order = ((String)params.get(table.getClientId(context) + "_columnOrder")).split(",");
        ArrayList<UIColumn> orderedColumns = new ArrayList<UIColumn>();
        String separator = String.valueOf(UINamingContainer.getSeparatorChar((FacesContext)context));
        block0: for (String columnId : order) {
            for (UIComponent child : table.getChildren()) {
                if (child instanceof Column && child.getClientId(context).equals(columnId)) {
                    orderedColumns.add((UIColumn)child);
                    continue block0;
                }
                if (!(child instanceof Columns) || !columnId.startsWith(child.getClientId(context))) continue;
                String[] ids = columnId.split(separator);
                int index = Integer.parseInt(ids[ids.length - 1]);
                orderedColumns.add(new DynamicColumn(index, (Columns)child));
                continue block0;
            }
        }
        table.setColumns(orderedColumns);
    }

    public void encode(FacesContext context, DataTableRenderer renderer, DataTable table) throws IOException {
        throw new RuntimeException("DraggableColumns Feature should not encode.");
    }

    public boolean shouldDecode(FacesContext context, DataTable table) {
        return table.isDraggableColumns();
    }

    public boolean shouldEncode(FacesContext context, DataTable table) {
        return false;
    }
}

