/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.management.interceptor;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.ObjectName;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.management.counters.CounterRepository;
import org.apache.cxf.management.counters.MessageHandlingTimeRecorder;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.FaultMode;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.OperationInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMessageResponseTimeInterceptor
extends AbstractPhaseInterceptor<Message> {
    private static final Logger LOG = LogUtils.getL7dLogger(AbstractMessageResponseTimeInterceptor.class);
    private static final String QUESTION_MARK = "?";
    private static final String ESCAPED_QUESTION_MARK = "\\?";

    AbstractMessageResponseTimeInterceptor(String phase) {
        super(phase);
    }

    protected boolean isClient(Message msg) {
        return msg == null ? false : Boolean.TRUE.equals(msg.get("org.apache.cxf.client"));
    }

    protected void beginHandlingMessage(Exchange ex) {
        if (null == ex) {
            return;
        }
        MessageHandlingTimeRecorder mhtr = ex.get(MessageHandlingTimeRecorder.class);
        if (null != mhtr) {
            mhtr.beginHandling();
        } else {
            mhtr = new MessageHandlingTimeRecorder(ex);
            mhtr.beginHandling();
        }
    }

    protected void endHandlingMessage(Exchange ex) {
        if (null == ex) {
            return;
        }
        MessageHandlingTimeRecorder mhtr = ex.get(MessageHandlingTimeRecorder.class);
        if (null != mhtr) {
            mhtr.endHandling();
            mhtr.setFaultMode(ex.get(FaultMode.class));
            this.increaseCounter(ex, mhtr);
        }
    }

    protected void setOneWayMessage(Exchange ex) {
        MessageHandlingTimeRecorder mhtr = ex.get(MessageHandlingTimeRecorder.class);
        if (null == mhtr) {
            mhtr = new MessageHandlingTimeRecorder(ex);
        } else {
            mhtr.endHandling();
        }
        mhtr.setOneWay(true);
        this.increaseCounter(ex, mhtr);
    }

    private void increaseCounter(Exchange ex, MessageHandlingTimeRecorder mhtr) {
        Object nameProperty;
        String operationName;
        Bus bus = ex.get(Bus.class);
        if (null == bus) {
            LOG.log(Level.INFO, "CAN_NOT_GET_BUS_FROM_EXCHANGE");
            BusFactory.getThreadDefaultBus();
        }
        Message message = ex.getOutMessage();
        CounterRepository cr = bus.getExtension(CounterRepository.class);
        if (null == cr) {
            LOG.log(Level.WARNING, "NO_COUNTER_REPOSITORY");
            return;
        }
        Service service = ex.get(Service.class);
        Endpoint endpoint = ex.get(Endpoint.class);
        String serviceName = "\"" + this.escapePatternChars(service.getName().toString()) + "\"";
        String portName = "\"" + endpoint.getEndpointInfo().getName().getLocalPart() + "\"";
        OperationInfo opInfo = ex.get(OperationInfo.class);
        String string = operationName = opInfo == null ? null : "\"" + opInfo.getName().getLocalPart() + "\"";
        if (operationName == null && (nameProperty = ex.get("org.apache.cxf.resource.operation.name")) != null) {
            operationName = "\"" + this.escapePatternChars(nameProperty.toString()) + "\"";
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append("org.apache.cxf:");
        buffer.append("bus.id=" + bus.getId() + ",");
        if (this.isClient(message)) {
            buffer.append("type=Performance.Counter.Client,");
        } else {
            buffer.append("type=Performance.Counter.Server,");
        }
        buffer.append("service=" + serviceName + ",");
        buffer.append("port=" + portName);
        String serviceCounterName = buffer.toString();
        try {
            ObjectName serviceCounter = new ObjectName(serviceCounterName);
            cr.increaseCounter(serviceCounter, mhtr);
            if (operationName != null) {
                buffer.append(",operation=" + operationName);
                String operationCounterName = buffer.toString();
                ObjectName operationCounter = new ObjectName(operationCounterName);
                cr.increaseCounter(operationCounter, mhtr);
            }
        }
        catch (Exception exception) {
            LOG.log(Level.WARNING, "CREATE_COUNTER_OBJECTNAME_FAILED", exception);
        }
    }

    protected String escapePatternChars(String value) {
        if (value.lastIndexOf(QUESTION_MARK) != -1) {
            value = value.replace(QUESTION_MARK, ESCAPED_QUESTION_MARK);
        }
        return value;
    }
}

