/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.traceAnalysis.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Collection;
import java.util.Properties;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import kieker.tools.traceAnalysis.gui.AbstractStep;
import kieker.tools.traceAnalysis.gui.util.AllSelectionBindingItemListener;

public class PrintStep
extends AbstractStep {
    private static final long serialVersionUID = 1L;
    private static final String PROPERTY_KEY_IDENTIFIER = PrintStep.class.getSimpleName();
    private static final String PROPERTY_KEY_MESSAGE_TRACES = PROPERTY_KEY_IDENTIFIER + ".messageTraces";
    private static final String PROPERTY_KEY_EXECUTION_TRACES = PROPERTY_KEY_IDENTIFIER + ".executionTraces";
    private static final String PROPERTY_KEY_INVALID_EXECUTION_TRACES = PROPERTY_KEY_IDENTIFIER + ".invalidExecutionTraces";
    private static final String PROPERTY_KEY_SYSTEM_MODEL = PROPERTY_KEY_IDENTIFIER + ".systemModel";
    private static final String PROPERTY_KEY_DEPLOYMENT_EQUIVALENCE_CLASSES = PROPERTY_KEY_IDENTIFIER + ".deploymentEquivalenceClasses";
    private static final String PROPERTY_KEY_ASSEMBLY_EQUIVALENCE_CLASSES = PROPERTY_KEY_IDENTIFIER + ".assemblyEquivalenceClasses";
    private final JLabel infoLabel = new JLabel("In this step you choose prints to be generated by the trace analysis.");
    private final JCheckBox messageTraces = new JCheckBox("Message Traces");
    private final JCheckBox executionTraces = new JCheckBox("Execution Traces");
    private final JCheckBox invalidExecutionTraces = new JCheckBox("Invalid Execution Traces");
    private final JCheckBox systemModel = new JCheckBox("System Model");
    private final JCheckBox deploymentEquivalenceClasses = new JCheckBox("Deployment Equivalence Classes");
    private final JCheckBox assemblyEquivalenceClasses = new JCheckBox("Assembly Equivalence Classes");
    private final JCheckBox allPrints = new JCheckBox("Select All");
    private final JPanel expandingPanel = new JPanel();

    public PrintStep() {
        this.addAndLayoutComponents();
        this.addLogicToComponents();
    }

    private void addAndLayoutComponents() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets.set(5, 5, 5, 5);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        this.add((Component)this.infoLabel, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets.set(5, 5, 0, 0);
        this.add((Component)this.messageTraces, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets.set(0, 5, 0, 0);
        this.add((Component)this.executionTraces, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets.set(0, 5, 0, 0);
        this.add((Component)this.invalidExecutionTraces, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets.set(0, 5, 0, 0);
        this.add((Component)this.systemModel, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets.set(0, 5, 0, 0);
        this.add((Component)this.deploymentEquivalenceClasses, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets.set(0, 5, 0, 0);
        this.add((Component)this.assemblyEquivalenceClasses, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets.set(10, 5, 5, 5);
        this.add((Component)this.allPrints, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 3;
        this.add((Component)this.expandingPanel, gridBagConstraints);
    }

    private void addLogicToComponents() {
        this.allPrints.addItemListener(new AllSelectionBindingItemListener(this.messageTraces, this.executionTraces, this.invalidExecutionTraces, this.systemModel, this.deploymentEquivalenceClasses, this.assemblyEquivalenceClasses));
    }

    @Override
    public boolean isNextStepAllowed() {
        boolean nothingSelected;
        boolean bl = nothingSelected = !this.messageTraces.isSelected() && !this.executionTraces.isSelected() && !this.invalidExecutionTraces.isSelected() && !this.systemModel.isSelected() && !this.deploymentEquivalenceClasses.isSelected() && !this.assemblyEquivalenceClasses.isSelected();
        if (nothingSelected) {
            int result = JOptionPane.showConfirmDialog(this, "No prints have been selected. Continue?", "No Prints Selected", 0, 2);
            return 0 == result;
        }
        return true;
    }

    @Override
    public void addSelectedTraceAnalysisParameters(Collection<String> parameters) {
        if (this.messageTraces.isSelected()) {
            parameters.add("--print-Message-Traces");
        }
        if (this.executionTraces.isSelected()) {
            parameters.add("--print-Execution-Traces");
        }
        if (this.invalidExecutionTraces.isSelected()) {
            parameters.add("--print-invalid-Execution-Traces");
        }
        if (this.systemModel.isSelected()) {
            parameters.add("--print-System-Model");
        }
        if (this.deploymentEquivalenceClasses.isSelected()) {
            parameters.add("--print-Deployment-Equivalence-Classes");
        }
        if (this.assemblyEquivalenceClasses.isSelected()) {
            parameters.add("--print-Assembly-Equivalence-Classes");
        }
    }

    @Override
    public void loadDefaultConfiguration() {
        this.systemModel.setSelected(true);
    }

    @Override
    public void saveCurrentConfiguration(Properties properties) {
        properties.setProperty(PROPERTY_KEY_MESSAGE_TRACES, Boolean.toString(this.messageTraces.isSelected()));
        properties.setProperty(PROPERTY_KEY_EXECUTION_TRACES, Boolean.toString(this.executionTraces.isSelected()));
        properties.setProperty(PROPERTY_KEY_INVALID_EXECUTION_TRACES, Boolean.toString(this.invalidExecutionTraces.isSelected()));
        properties.setProperty(PROPERTY_KEY_SYSTEM_MODEL, Boolean.toString(this.systemModel.isSelected()));
        properties.setProperty(PROPERTY_KEY_DEPLOYMENT_EQUIVALENCE_CLASSES, Boolean.toString(this.deploymentEquivalenceClasses.isSelected()));
        properties.setProperty(PROPERTY_KEY_ASSEMBLY_EQUIVALENCE_CLASSES, Boolean.toString(this.assemblyEquivalenceClasses.isSelected()));
    }

    @Override
    public void loadCurrentConfiguration(Properties properties) {
        this.messageTraces.setSelected(Boolean.parseBoolean(properties.getProperty(PROPERTY_KEY_MESSAGE_TRACES)));
        this.executionTraces.setSelected(Boolean.parseBoolean(properties.getProperty(PROPERTY_KEY_EXECUTION_TRACES)));
        this.invalidExecutionTraces.setSelected(Boolean.parseBoolean(properties.getProperty(PROPERTY_KEY_INVALID_EXECUTION_TRACES)));
        this.systemModel.setSelected(Boolean.parseBoolean(properties.getProperty(PROPERTY_KEY_SYSTEM_MODEL)));
        this.deploymentEquivalenceClasses.setSelected(Boolean.parseBoolean(properties.getProperty(PROPERTY_KEY_DEPLOYMENT_EQUIVALENCE_CLASSES)));
        this.assemblyEquivalenceClasses.setSelected(Boolean.parseBoolean(properties.getProperty(PROPERTY_KEY_ASSEMBLY_EQUIVALENCE_CLASSES)));
    }
}

