/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.logReplayer;

import java.util.Arrays;
import kieker.analysis.IAnalysisController;
import kieker.analysis.plugin.reader.AbstractReaderPlugin;
import kieker.analysis.plugin.reader.filesystem.FSReader;
import kieker.common.configuration.Configuration;
import kieker.tools.logReplayer.AbstractLogReplayer;

public class FilesystemLogReplayer
extends AbstractLogReplayer {
    private final String[] inputDirs;

    public FilesystemLogReplayer(String monitoringConfigurationFile, boolean realtimeMode, double realtimeAccelerationFactor, boolean keepOriginalLoggingTimestamps, int numRealtimeWorkerThreads, long ignoreRecordsBeforeTimestamp, long ignoreRecordsAfterTimestamp, String[] inputDirs) {
        super(monitoringConfigurationFile, realtimeMode, realtimeAccelerationFactor, keepOriginalLoggingTimestamps, numRealtimeWorkerThreads, ignoreRecordsBeforeTimestamp, ignoreRecordsAfterTimestamp);
        this.inputDirs = Arrays.copyOf(inputDirs, inputDirs.length);
    }

    @Override
    protected AbstractReaderPlugin createReader(IAnalysisController analysisInstance) {
        Configuration configuration = new Configuration();
        configuration.setProperty("inputDirs", Configuration.toProperty(this.inputDirs));
        configuration.setProperty("ignoreUnknownRecordTypes", Boolean.toString(true));
        return new FSReader(configuration, analysisInstance);
    }

    @Override
    protected String readerOutputPortName() {
        return "monitoringRecords";
    }
}

