/*
 * Decompiled with CFR 0.152.
 */
package kieker.common.record.flow.trace;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import kieker.common.record.flow.AbstractEvent;
import kieker.common.record.flow.ITraceRecord;
import kieker.common.util.registry.IRegistry;

public abstract class AbstractTraceEvent
extends AbstractEvent
implements ITraceRecord {
    private static final long serialVersionUID = 161681009968355282L;
    private final long traceId;
    private final int orderIndex;

    public AbstractTraceEvent(long timestamp, long traceId, int orderIndex) {
        super(timestamp);
        this.traceId = traceId;
        this.orderIndex = orderIndex;
    }

    protected AbstractTraceEvent(Object[] values, Class<?>[] valueTypes) {
        super(values, valueTypes);
        this.traceId = (Long)values[1];
        this.orderIndex = (Integer)values[2];
    }

    public AbstractTraceEvent(ByteBuffer buffer, IRegistry<String> stringRegistry) throws BufferUnderflowException {
        super(buffer, stringRegistry);
        this.traceId = buffer.getLong();
        this.orderIndex = buffer.getInt();
    }

    @Override
    @Deprecated
    public void initFromArray(Object[] values) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void initFromBytes(ByteBuffer buffer, IRegistry<String> stringRegistry) throws BufferUnderflowException {
        throw new UnsupportedOperationException();
    }

    @Override
    public final long getTraceId() {
        return this.traceId;
    }

    @Override
    public final int getOrderIndex() {
        return this.orderIndex;
    }
}

