/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.tslib;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kieker.tools.tslib.ITimeSeries;
import kieker.tools.tslib.ITimeSeriesPoint;
import kieker.tools.tslib.TimeSeriesPoint;
import kieker.tools.tslib.TimeSeriesPointsBuffer;

public class TimeSeries<T>
implements ITimeSeries<T> {
    private volatile long startTime;
    private final TimeUnit timeSeriesTimeUnit;
    private long nextTime;
    private final long deltaTime;
    private final TimeUnit deltaTimeUnit;
    private final int frequency;
    private final int capacity;
    private final TimeSeriesPointsBuffer<ITimeSeriesPoint<T>> points;
    private final long timeSeriesStepSize;

    public TimeSeries(long startTime, TimeUnit timeSeriesTimeUnit, long deltaTime, TimeUnit deltaTimeUnit, int frequency, int capacity) {
        this.startTime = startTime;
        this.timeSeriesTimeUnit = timeSeriesTimeUnit;
        this.deltaTime = deltaTime;
        this.deltaTimeUnit = deltaTimeUnit;
        this.frequency = frequency;
        this.capacity = capacity;
        this.timeSeriesStepSize = timeSeriesTimeUnit.convert(this.deltaTime, this.deltaTimeUnit);
        this.points = -1 == capacity ? new TimeSeriesPointsBuffer() : new TimeSeriesPointsBuffer(this.capacity);
        this.nextTime = this.startTime;
    }

    public TimeSeries(long startTime, TimeUnit timeSeriesTimeUnit, long deltaTime, TimeUnit deltaTimeUnit, int capacity) {
        this(startTime, timeSeriesTimeUnit, deltaTime, deltaTimeUnit, 24, capacity);
    }

    public TimeSeries(long startTime, TimeUnit timeSeriesTimeUnit, long deltaTime, TimeUnit deltaTimeUnit) {
        this(startTime, timeSeriesTimeUnit, deltaTime, deltaTimeUnit, -1);
    }

    public TimeSeries(long startTime, TimeUnit timeUnit, long deltaTime) {
        this(startTime, timeUnit, deltaTime, timeUnit);
    }

    public TimeSeries(long startTime, TimeUnit timeUnit, long deltaTime, int frequency, int capacity) {
        this(startTime, timeUnit, deltaTime, timeUnit, frequency, capacity);
    }

    public TimeSeries(long startTime, TimeUnit timeUnit, long deltaTime, int frequency) {
        this(startTime, timeUnit, deltaTime, timeUnit, frequency, -1);
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public TimeUnit getTimeSeriesTimeUnit() {
        return this.timeSeriesTimeUnit;
    }

    @Override
    public long getDeltaTime() {
        return this.deltaTime;
    }

    @Override
    public TimeUnit getDeltaTimeUnit() {
        return this.deltaTimeUnit;
    }

    public long getStepSize() {
        return this.timeSeriesStepSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ITimeSeriesPoint<T> append(T value) {
        TimeSeriesPoint<T> point;
        T t = value;
        synchronized (t) {
            point = new TimeSeriesPoint<T>(this.nextTime, value);
            this.points.add((ITimeSeriesPoint<TimeSeriesPoint<T>>)point);
            this.startTime = ((ITimeSeriesPoint)this.points.peek()).getTime();
            this.nextTime += this.timeSeriesStepSize;
        }
        return point;
    }

    @Override
    public List<ITimeSeriesPoint<T>> getPoints() {
        return new ArrayList<ITimeSeriesPoint<T>>(this.points);
    }

    @Override
    public List<T> getValues() {
        List<ITimeSeriesPoint<T>> pointsCopy = this.getPoints();
        ArrayList<T> retVals = new ArrayList<T>(pointsCopy.size());
        for (ITimeSeriesPoint<T> curPoint : pointsCopy) {
            retVals.add(curPoint.getValue());
        }
        return retVals;
    }

    @Override
    public int getCapacity() {
        return this.capacity;
    }

    @Override
    public int size() {
        return this.points.getSize();
    }

    @Override
    public long getEndTime() {
        if (this.getPoints().isEmpty()) {
            throw new IllegalStateException("The TimeSeries is empty, so no end time can be returned.");
        }
        return this.getStartTime() + this.timeSeriesStepSize * (long)(this.getPoints().size() - 1);
    }

    @Override
    public List<ITimeSeriesPoint<T>> appendAll(T[] values) {
        ArrayList<ITimeSeriesPoint<T>> retVals = new ArrayList<ITimeSeriesPoint<T>>(values.length);
        for (T value : values) {
            retVals.add(this.append(value));
        }
        return retVals;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Time Series with delta: " + this.deltaTime + " " + (Object)((Object)this.deltaTimeUnit) + " starting at: " + this.getStartTime() + " " + (Object)((Object)this.timeSeriesTimeUnit));
        for (ITimeSeriesPoint<T> curPoint : this.getPoints()) {
            buf.append(curPoint);
        }
        return buf.toString();
    }

    @Override
    public int getFrequency() {
        return this.frequency;
    }
}

