/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.traceAnalysis.filter.visualization.callTree;

import kieker.analysis.IProjectContext;
import kieker.analysis.plugin.annotation.Plugin;
import kieker.analysis.plugin.annotation.RepositoryPort;
import kieker.common.configuration.Configuration;
import kieker.tools.traceAnalysis.filter.visualization.callTree.AbstractAggregatedCallTreeFilter;
import kieker.tools.traceAnalysis.filter.visualization.callTree.AggregatedAssemblyComponentOperationCallTreeNode;
import kieker.tools.traceAnalysis.filter.visualization.graph.IOriginRetentionPolicy;
import kieker.tools.traceAnalysis.filter.visualization.graph.NoOriginRetentionPolicy;
import kieker.tools.traceAnalysis.systemModel.AssemblyComponent;
import kieker.tools.traceAnalysis.systemModel.Operation;
import kieker.tools.traceAnalysis.systemModel.SynchronousCallMessage;
import kieker.tools.traceAnalysis.systemModel.repository.AssemblyComponentOperationPairFactory;
import kieker.tools.traceAnalysis.systemModel.repository.SystemModelRepository;
import kieker.tools.traceAnalysis.systemModel.util.AssemblyComponentOperationPair;

@Plugin(description="Uses the incoming data to enrich the connected repository with data for the aggregated assembly component operation call tree", repositoryPorts={@RepositoryPort(name="systemModelRepository", repositoryType=SystemModelRepository.class)})
public class AggregatedAssemblyComponentOperationCallTreeFilter
extends AbstractAggregatedCallTreeFilter<AssemblyComponentOperationPair> {
    public AggregatedAssemblyComponentOperationCallTreeFilter(Configuration configuration, IProjectContext projectContext) {
        super(configuration, projectContext);
    }

    @Override
    public boolean init() {
        boolean success = super.init();
        if (success) {
            super.setRoot(new AggregatedAssemblyComponentOperationCallTreeNode(0, AssemblyComponentOperationPairFactory.ROOT_PAIR, true, null, (IOriginRetentionPolicy)NoOriginRetentionPolicy.createInstance()));
        }
        return success;
    }

    @Override
    protected AssemblyComponentOperationPair concreteCreatePair(SynchronousCallMessage callMsg) {
        AssemblyComponent assemblyComponent = callMsg.getReceivingExecution().getAllocationComponent().getAssemblyComponent();
        Operation op = callMsg.getReceivingExecution().getOperation();
        return this.getSystemEntityFactory().getAssemblyPairFactory().getPairInstanceByPair(assemblyComponent, op);
    }
}

