/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.bridge.connector.tcp;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.Socket;
import java.net.SocketException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentMap;
import kieker.common.logging.Log;
import kieker.common.logging.LogFactory;
import kieker.common.record.IMonitoringRecord;
import kieker.tools.bridge.LookupEntity;
import kieker.tools.bridge.connector.ConnectorDataTransmissionException;
import kieker.tools.bridge.connector.ConnectorEndOfDataException;

public class TCPMultiServerConnectionRunnable
implements Runnable {
    private static final int BUF_LEN = 65536;
    private static final Log LOG = LogFactory.getLog(TCPMultiServerConnectionRunnable.class);
    private final Socket socket;
    private final byte[] buffer = new byte[65536];
    private final ConcurrentMap<Integer, LookupEntity> lookupEntityMap;
    private final BlockingQueue<IMonitoringRecord> recordQueue;
    private volatile boolean active;

    public TCPMultiServerConnectionRunnable(Socket socket, ConcurrentMap<Integer, LookupEntity> lookupEntityMap, BlockingQueue<IMonitoringRecord> recordQueue) {
        this.socket = socket;
        this.lookupEntityMap = lookupEntityMap;
        this.recordQueue = recordQueue;
    }

    @Override
    public void run() {
        this.active = true;
        try {
            DataInputStream in = new DataInputStream(this.socket.getInputStream());
            while (this.active) {
                try {
                    this.recordQueue.put(this.deserialize(in));
                }
                catch (InterruptedException e) {
                    this.active = false;
                    LOG.warn("Listener " + Thread.currentThread().getId() + " died.", e);
                }
                catch (ConnectorDataTransmissionException e) {
                    this.active = false;
                    LOG.warn("Listener " + Thread.currentThread().getId() + " died.", e);
                }
                catch (ConnectorEndOfDataException e) {
                    this.active = false;
                    LOG.info("Listener " + Thread.currentThread().getId() + " terminated at end of stream.");
                }
            }
            in.close();
            this.socket.close();
        }
        catch (IOException e) {
            this.active = false;
            LOG.warn("IO exception occurred. Cause " + e.getMessage());
        }
    }

    private IMonitoringRecord deserialize(DataInputStream in) throws ConnectorDataTransmissionException, ConnectorEndOfDataException {
        try {
            Integer id = in.readInt();
            LookupEntity recordProperty = (LookupEntity)this.lookupEntityMap.get(id);
            if (recordProperty != null) {
                Object[] values = new Object[recordProperty.getParameterTypes().length];
                for (int i = 0; i < recordProperty.getParameterTypes().length; ++i) {
                    Class<?> parameterType = recordProperty.getParameterTypes()[i];
                    if (Boolean.TYPE.equals(parameterType)) {
                        values[i] = in.readBoolean();
                        continue;
                    }
                    if (Boolean.class.equals(parameterType)) {
                        values[i] = in.readBoolean();
                        continue;
                    }
                    if (Byte.TYPE.equals(parameterType)) {
                        values[i] = in.readByte();
                        continue;
                    }
                    if (Byte.class.equals(parameterType)) {
                        values[i] = in.readByte();
                        continue;
                    }
                    if (Short.TYPE.equals(parameterType)) {
                        values[i] = in.readShort();
                        continue;
                    }
                    if (Short.class.equals(parameterType)) {
                        values[i] = in.readShort();
                        continue;
                    }
                    if (Integer.TYPE.equals(parameterType)) {
                        values[i] = in.readInt();
                        continue;
                    }
                    if (Integer.class.equals(parameterType)) {
                        values[i] = in.readInt();
                        continue;
                    }
                    if (Long.TYPE.equals(parameterType)) {
                        values[i] = in.readLong();
                        continue;
                    }
                    if (Long.class.equals(parameterType)) {
                        values[i] = in.readLong();
                        continue;
                    }
                    if (Float.TYPE.equals(parameterType)) {
                        values[i] = Float.valueOf(in.readFloat());
                        continue;
                    }
                    if (Float.class.equals(parameterType)) {
                        values[i] = Float.valueOf(in.readFloat());
                        continue;
                    }
                    if (Double.TYPE.equals(parameterType)) {
                        values[i] = in.readDouble();
                        continue;
                    }
                    if (Double.class.equals(parameterType)) {
                        values[i] = in.readDouble();
                        continue;
                    }
                    if (String.class.equals(parameterType)) {
                        int bufLen = in.readInt();
                        in.readFully(this.buffer, 0, bufLen);
                        values[i] = new String(this.buffer, 0, bufLen, "UTF-8");
                        continue;
                    }
                    throw new ConnectorDataTransmissionException("References are not yet supported.");
                }
                return recordProperty.getConstructor().newInstance(values);
            }
            throw new IOException("Record type " + id + " is not registered.");
        }
        catch (SocketException e) {
            throw new ConnectorEndOfDataException("End of stream", e);
        }
        catch (EOFException e) {
            throw new ConnectorEndOfDataException("End of stream", e);
        }
        catch (IOException e) {
            throw new ConnectorDataTransmissionException("Read error", e);
        }
        catch (InstantiationException e) {
            throw new ConnectorDataTransmissionException("Instantiation error", e);
        }
        catch (IllegalAccessException e) {
            throw new ConnectorDataTransmissionException("Access to fields are restricted", e);
        }
        catch (IllegalArgumentException e) {
            throw new ConnectorDataTransmissionException(e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            throw new ConnectorDataTransmissionException(e.getMessage(), e);
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }
}

