/*
 * Decompiled with CFR 0.152.
 */
package kieker.common.util.registry;

import kieker.common.util.registry.ILookup;
import kieker.common.util.registry.IMonitoringRecordReceiver;

public final class Lookup<E>
implements ILookup<E> {
    private volatile transient E[] array = new Object[0];

    @Override
    public int get(E value) {
        E[] arr = this.array;
        if (value != null) {
            for (int i = 0; i < arr.length; ++i) {
                if (!value.equals(arr[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public E getNonBlocking(int i) {
        E[] arr = this.array;
        if (i < arr.length) {
            return arr[i];
        }
        return null;
    }

    @Override
    public E[] getAll() {
        E[] arr = this.array;
        Object[] result = new Object[arr.length];
        System.arraycopy(arr, 0, result, 0, arr.length);
        return result;
    }

    @Override
    public int getSize() {
        return this.array.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E get(int i) {
        Lookup lookup = this;
        synchronized (lookup) {
            E value = this.getNonBlocking(i);
            while (null == value) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    return null;
                }
                value = this.get(i);
            }
            return value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean set(E value, int id) {
        Lookup lookup = this;
        synchronized (lookup) {
            if (id < this.array.length) {
                if (null == this.array[id]) {
                    this.array[id] = value;
                    this.notifyAll();
                    return true;
                }
                return false;
            }
            Object[] newArray = new Object[id + 1];
            System.arraycopy(this.array, 0, newArray, 0, this.array.length);
            newArray[id] = value;
            this.array = newArray;
            this.notifyAll();
            return true;
        }
    }

    @Override
    @Deprecated
    public void setRecordReceiver(IMonitoringRecordReceiver recordReceiver) {
        throw new UnsupportedOperationException();
    }
}

