/*
 * Decompiled with CFR 0.152.
 */
package kieker.common.record.flow.trace;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import kieker.common.record.AbstractMonitoringRecord;
import kieker.common.record.IMonitoringRecord;
import kieker.common.record.flow.IFlowRecord;
import kieker.common.util.registry.IRegistry;

public class TraceMetadata
extends AbstractMonitoringRecord
implements IMonitoringRecord.Factory,
IMonitoringRecord.BinaryFactory,
IFlowRecord {
    public static final int SIZE = 36;
    public static final Class<?>[] TYPES = new Class[]{Long.TYPE, Long.TYPE, String.class, String.class, Long.TYPE, Integer.TYPE};
    public static final String NO_SESSION_ID = "<no-session-id>";
    public static final String NO_HOSTNAME = "<default-host>";
    public static final long NO_PARENT_TRACEID = -1L;
    public static final int NO_PARENT_ORDER_INDEX = -1;
    private static final long serialVersionUID = 5676916633570574411L;
    private final long traceId;
    private final long threadId;
    private final String sessionId;
    private final String hostname;
    private final long parentTraceId;
    private final int parentOrderId;
    private transient int nextOrderId = 0;

    public TraceMetadata(long traceId, long threadId, String sessionId, String hostname, long parentTraceId, int parentOrderId) {
        this.traceId = traceId;
        this.threadId = threadId;
        this.sessionId = sessionId == null ? NO_SESSION_ID : sessionId;
        this.hostname = hostname == null ? NO_HOSTNAME : hostname;
        this.parentTraceId = parentTraceId;
        this.parentOrderId = parentOrderId;
    }

    public TraceMetadata(Object[] values) {
        AbstractMonitoringRecord.checkArray(values, TYPES);
        this.traceId = (Long)values[0];
        this.threadId = (Long)values[1];
        this.sessionId = (String)values[2];
        this.hostname = (String)values[3];
        this.parentTraceId = (Long)values[4];
        this.parentOrderId = (Integer)values[5];
    }

    public TraceMetadata(ByteBuffer buffer, IRegistry<String> stringRegistry) throws BufferUnderflowException {
        this.traceId = buffer.getLong();
        this.threadId = buffer.getLong();
        this.sessionId = stringRegistry.get(buffer.getInt());
        this.hostname = stringRegistry.get(buffer.getInt());
        this.parentTraceId = buffer.getLong();
        this.parentOrderId = buffer.getInt();
    }

    @Override
    public Object[] toArray() {
        return new Object[]{this.getTraceId(), this.getThreadId(), this.getSessionId(), this.getHostname(), this.getParentTraceId(), this.getParentOrderId()};
    }

    @Override
    public void writeBytes(ByteBuffer buffer, IRegistry<String> stringRegistry) throws BufferOverflowException {
        buffer.putLong(this.getTraceId());
        buffer.putLong(this.getThreadId());
        buffer.putInt(stringRegistry.get(this.getSessionId()));
        buffer.putInt(stringRegistry.get(this.getHostname()));
        buffer.putLong(this.getParentTraceId());
        buffer.putInt(this.getParentOrderId());
    }

    @Override
    @Deprecated
    public final void initFromArray(Object[] values) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final void initFromBytes(ByteBuffer buffer, IRegistry<String> stringRegistry) throws BufferUnderflowException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Class<?>[] getValueTypes() {
        return TYPES;
    }

    @Override
    public int getSize() {
        return 36;
    }

    public final long getTraceId() {
        return this.traceId;
    }

    public final long getThreadId() {
        return this.threadId;
    }

    public final String getSessionId() {
        return this.sessionId;
    }

    public final String getHostname() {
        return this.hostname;
    }

    public final long getParentTraceId() {
        return this.parentTraceId;
    }

    public final int getParentOrderId() {
        return this.parentOrderId;
    }

    public final int getNextOrderId() {
        return this.nextOrderId++;
    }
}

