/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.plugin.reader.tcp;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import kieker.analysis.IProjectContext;
import kieker.analysis.plugin.annotation.OutputPort;
import kieker.analysis.plugin.annotation.Plugin;
import kieker.analysis.plugin.annotation.Property;
import kieker.analysis.plugin.reader.AbstractReaderPlugin;
import kieker.analysis.plugin.reader.tcp.TCPStringReader;
import kieker.common.configuration.Configuration;
import kieker.common.exception.MonitoringRecordException;
import kieker.common.record.AbstractMonitoringRecord;
import kieker.common.record.IMonitoringRecord;
import kieker.common.util.registry.ILookup;
import kieker.common.util.registry.Lookup;

@Plugin(description="A reader which reads records from a TCP port", outputPorts={@OutputPort(name="monitoringRecords", eventTypes={IMonitoringRecord.class}, description="Output Port of the TCPReader")}, configuration={@Property(name="port1", defaultValue="10133", description="The first port of the server used for the TCP connection."), @Property(name="port2", defaultValue="10134", description="The second port of the server used for the TCP connection.")})
public final class TCPReader
extends AbstractReaderPlugin {
    public static final String OUTPUT_PORT_NAME_RECORDS = "monitoringRecords";
    public static final String CONFIG_PROPERTY_NAME_PORT1 = "port1";
    public static final String CONFIG_PROPERTY_NAME_PORT2 = "port2";
    private static final int MESSAGE_BUFFER_SIZE = 65535;
    private volatile Thread readerThread;
    private volatile TCPStringReader tcpStringReader;
    private volatile boolean terminated = false;
    private final int port1;
    private final int port2;
    private final ILookup<String> stringRegistry = new Lookup<String>();

    public TCPReader(Configuration configuration, IProjectContext projectContext) {
        super(configuration, projectContext);
        this.port1 = this.configuration.getIntProperty(CONFIG_PROPERTY_NAME_PORT1);
        this.port2 = this.configuration.getIntProperty(CONFIG_PROPERTY_NAME_PORT2);
    }

    @Override
    public boolean init() {
        this.tcpStringReader = new TCPStringReader(this.port2, this.stringRegistry);
        this.tcpStringReader.start();
        return super.init();
    }

    @Override
    public Configuration getCurrentConfiguration() {
        Configuration configuration = new Configuration();
        configuration.setProperty(CONFIG_PROPERTY_NAME_PORT1, Integer.toString(this.port1));
        configuration.setProperty(CONFIG_PROPERTY_NAME_PORT2, Integer.toString(this.port2));
        return configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean read() {
        this.readerThread = Thread.currentThread();
        ServerSocketChannel serversocket = null;
        try {
            serversocket = ServerSocketChannel.open();
            serversocket.socket().bind(new InetSocketAddress(this.port1));
            if (this.log.isDebugEnabled()) {
                this.log.debug("Listening on port " + this.port1);
            }
            SocketChannel socketChannel = serversocket.accept();
            ByteBuffer buffer = ByteBuffer.allocateDirect(65535);
            while (true) {
                if (socketChannel.read(buffer) == -1 || this.terminated) {
                    socketChannel.close();
                    return true;
                }
                buffer.flip();
                try {
                    while (buffer.hasRemaining()) {
                        buffer.mark();
                        int clazzid = buffer.getInt();
                        long loggingTimestamp = buffer.getLong();
                        try {
                            IMonitoringRecord record = AbstractMonitoringRecord.createFromByteBuffer(clazzid, buffer, this.stringRegistry);
                            record.setLoggingTimestamp(loggingTimestamp);
                            super.deliver(OUTPUT_PORT_NAME_RECORDS, record);
                        }
                        catch (MonitoringRecordException ex) {
                            this.log.error("Failed to create record.", ex);
                        }
                    }
                    buffer.clear();
                }
                catch (BufferUnderflowException ex) {
                    buffer.reset();
                    buffer.compact();
                }
            }
        }
        catch (ClosedByInterruptException ex) {
            this.log.warn("Reader interrupted", ex);
            boolean bl = this.terminated;
            return bl;
        }
        catch (IOException ex) {
            this.log.error("Error while reading", ex);
            boolean bl = false;
            return bl;
        }
        finally {
            block24: {
                if (null != serversocket) {
                    try {
                        serversocket.close();
                    }
                    catch (IOException e) {
                        if (!this.log.isDebugEnabled()) break block24;
                        this.log.debug("Failed to close TCP connection!", e);
                    }
                }
            }
        }
    }

    @Override
    public void terminate(boolean error) {
        this.log.info("Shutdown of TCPReader requested.");
        this.terminated = true;
        this.readerThread.interrupt();
        this.tcpStringReader.terminate();
    }
}

