/*
 * Decompiled with CFR 0.152.
 */
package kieker.examples.userguide.appendixSigar;

import kieker.analysis.IProjectContext;
import kieker.analysis.plugin.annotation.InputPort;
import kieker.analysis.plugin.annotation.Plugin;
import kieker.analysis.plugin.filter.AbstractFilterPlugin;
import kieker.common.configuration.Configuration;
import kieker.common.record.IMonitoringRecord;
import kieker.common.record.system.CPUUtilizationRecord;
import kieker.common.record.system.MemSwapUsageRecord;
import kieker.tools.util.LoggingTimestampConverter;

@Plugin
class StdOutDumpConsumer
extends AbstractFilterPlugin {
    public static final String INPUT_PORT_NAME = "newMonitoringRecord";

    public StdOutDumpConsumer(Configuration configuration, IProjectContext iProjectContext) {
        super(configuration, iProjectContext);
    }

    @InputPort(name="newMonitoringRecord", eventTypes={IMonitoringRecord.class})
    public void newMonitoringRecord(Object object) {
        if (object instanceof CPUUtilizationRecord) {
            CPUUtilizationRecord cPUUtilizationRecord = (CPUUtilizationRecord)object;
            String string = cPUUtilizationRecord.getHostname();
            String string2 = cPUUtilizationRecord.getCpuID();
            double d = cPUUtilizationRecord.getTotalUtilization() * 100.0;
            System.out.println(String.format("%s: [CPU] host: %s ; cpu-id: %s ; utilization: %3.2f %%", LoggingTimestampConverter.convertLoggingTimestampToUTCString((long)cPUUtilizationRecord.getTimestamp()), string, string2, d));
        } else if (object instanceof MemSwapUsageRecord) {
            MemSwapUsageRecord memSwapUsageRecord = (MemSwapUsageRecord)object;
            String string = memSwapUsageRecord.getHostname();
            double d = (double)memSwapUsageRecord.getMemUsed() / 1048576.0;
            double d2 = (double)memSwapUsageRecord.getSwapUsed() / 1048576.0;
            System.out.println(String.format("%s: [Mem/Swap] host: %s ; mem usage: %s MB ; swap usage: %s MB", LoggingTimestampConverter.convertLoggingTimestampToUTCString((long)memSwapUsageRecord.getTimestamp()), string, d, d2));
        }
    }

    public Configuration getCurrentConfiguration() {
        return new Configuration();
    }
}

