/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.traceAnalysis.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import kieker.tools.traceAnalysis.gui.AbstractStep;

public class FinalStep
extends AbstractStep {
    private static final long serialVersionUID = 1L;
    private final JLabel infoLabel = new JLabel("All necessary information have been gathered. You can now start the trace analysis.");
    private final JButton startButton = new JButton("Start");
    private final JButton clearLogButton = new JButton("Clear Log");
    private final JTextArea logArea = new JTextArea(20, 60);
    private final JScrollPane logScrollPane = new JScrollPane(this.logArea);
    private final ActionListener startTraceAnalysisClickListener;

    public FinalStep(ActionListener startTraceAnalysisClickListener) {
        this.startTraceAnalysisClickListener = startTraceAnalysisClickListener;
        this.redirectOutputStreams();
        this.initializeComponents();
        this.addAndLayoutComponents();
        this.addLogicToComponents();
    }

    private void redirectOutputStreams() {
        LogOutputStream logOutputStream = new LogOutputStream();
        PrintStream logPrintStream = new PrintStream(logOutputStream);
        System.setOut(logPrintStream);
        System.setErr(logPrintStream);
    }

    private void initializeComponents() {
        this.logArea.setBorder(BorderFactory.createBevelBorder(1));
        this.logArea.setEditable(false);
    }

    private void addAndLayoutComponents() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints infoLabelConstraint = new GridBagConstraints();
        infoLabelConstraint.gridwidth = 0;
        infoLabelConstraint.anchor = 18;
        infoLabelConstraint.insets.set(5, 5, 5, 5);
        infoLabelConstraint.weightx = 1.0;
        infoLabelConstraint.fill = 2;
        this.add((Component)this.infoLabel, infoLabelConstraint);
        GridBagConstraints startButtonConstraint = new GridBagConstraints();
        startButtonConstraint.gridwidth = -1;
        startButtonConstraint.anchor = 18;
        startButtonConstraint.insets.set(5, 5, 5, 5);
        this.add((Component)this.startButton, startButtonConstraint);
        GridBagConstraints clearLogButtonConstraint = new GridBagConstraints();
        clearLogButtonConstraint.gridwidth = 0;
        clearLogButtonConstraint.anchor = 18;
        clearLogButtonConstraint.insets.set(5, 5, 5, 5);
        this.add((Component)this.clearLogButton, clearLogButtonConstraint);
        GridBagConstraints logScrollPaneConstraint = new GridBagConstraints();
        logScrollPaneConstraint.gridwidth = 0;
        logScrollPaneConstraint.gridheight = 0;
        logScrollPaneConstraint.anchor = 10;
        logScrollPaneConstraint.insets.set(5, 5, 5, 5);
        logScrollPaneConstraint.weighty = 1.0;
        logScrollPaneConstraint.fill = 1;
        this.add((Component)this.logScrollPane, logScrollPaneConstraint);
    }

    private void addLogicToComponents() {
        this.startButton.addActionListener(this.startTraceAnalysisClickListener);
        this.clearLogButton.addActionListener(new ClearLogClickListener());
    }

    public void disableButtons() {
        this.startButton.setEnabled(false);
    }

    public void enableButtons() {
        this.startButton.setEnabled(true);
    }

    @Override
    public void addSelectedTraceAnalysisParameters(Collection<String> parameters) {
    }

    @Override
    public void loadDefaultConfiguration() {
    }

    @Override
    public void saveCurrentConfiguration(Properties properties) {
    }

    @Override
    public void loadCurrentConfiguration(Properties properties) {
    }

    @Override
    public boolean isNextStepAllowed() {
        return false;
    }

    private final class LogOutputStream
    extends OutputStream {
        private final String lineSeperator = System.getProperty("line.separator");
        private final StringBuffer stringBuffer = new StringBuffer();

        @Override
        public synchronized void write(int data) throws IOException {
            this.stringBuffer.appendCodePoint(data);
            if (this.stringBuffer.lastIndexOf(this.lineSeperator) != -1) {
                FinalStep.this.logArea.append(this.stringBuffer.toString());
                this.stringBuffer.setLength(0);
            }
        }
    }

    private final class ClearLogClickListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            FinalStep.this.logArea.setText("");
        }
    }
}

