/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.opad.record;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import kieker.common.record.AbstractMonitoringRecord;
import kieker.common.record.IMonitoringRecord;
import kieker.common.util.registry.IRegistry;

public class NamedDoubleRecord
extends AbstractMonitoringRecord
implements IMonitoringRecord.Factory,
IMonitoringRecord.BinaryFactory {
    public static final int SIZE = 20;
    private static final long serialVersionUID = -4019655212544863655L;
    public static final Class<?>[] TYPES = new Class[]{String.class, Long.TYPE, Double.TYPE};
    private final String applicationName;
    private final long timestamp;
    private final double responseTime;

    public NamedDoubleRecord(String applicationName, long timestamp, double responseTime) {
        this.applicationName = applicationName == null ? "" : applicationName;
        this.timestamp = timestamp;
        this.responseTime = responseTime;
    }

    public NamedDoubleRecord(Object[] values) {
        AbstractMonitoringRecord.checkArray(values, TYPES);
        this.applicationName = (String)values[0];
        this.timestamp = (Long)values[1];
        this.responseTime = (Double)values[2];
    }

    protected NamedDoubleRecord(Object[] values, Class<?>[] valueTypes) {
        AbstractMonitoringRecord.checkArray(values, valueTypes);
        this.applicationName = (String)values[0];
        this.timestamp = (Long)values[1];
        this.responseTime = (Double)values[2];
    }

    public NamedDoubleRecord(ByteBuffer buffer, IRegistry<String> stringRegistry) throws BufferUnderflowException {
        this.applicationName = stringRegistry.get(buffer.getInt());
        this.timestamp = buffer.getLong();
        this.responseTime = buffer.getDouble();
    }

    @Override
    public Object[] toArray() {
        return new Object[]{this.getApplicationName(), this.getTimestamp(), this.getResponseTime()};
    }

    @Override
    public void writeBytes(ByteBuffer buffer, IRegistry<String> stringRegistry) throws BufferOverflowException {
        buffer.putInt(stringRegistry.get(this.getApplicationName()));
        buffer.putLong(this.getTimestamp());
        buffer.putDouble(this.getResponseTime());
    }

    @Override
    public Class<?>[] getValueTypes() {
        return TYPES;
    }

    @Override
    public int getSize() {
        return 20;
    }

    @Override
    @Deprecated
    public void initFromArray(Object[] values) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void initFromBytes(ByteBuffer buffer, IRegistry<String> stringRegistry) throws BufferUnderflowException {
        throw new UnsupportedOperationException();
    }

    public final String getApplicationName() {
        return this.applicationName;
    }

    public final long getTimestamp() {
        return this.timestamp;
    }

    public final double getResponseTime() {
        return this.responseTime;
    }
}

