/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.loggingTimestampConverter;

import kieker.common.logging.Log;
import kieker.common.logging.LogFactory;
import kieker.tools.AbstractCommandLineTool;
import kieker.tools.util.LoggingTimestampConverter;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public final class LoggingTimestampConverterTool
extends AbstractCommandLineTool {
    private static final Log LOG = LogFactory.getLog(LoggingTimestampConverterTool.class);
    private static final String FLAG_TIMESTAMPS_PARAMETER = "t";
    private long[] timestampsLong;

    private LoggingTimestampConverterTool() {
        super(true);
    }

    public static void main(String[] args) {
        new LoggingTimestampConverterTool().start(args);
    }

    @Override
    protected void addAdditionalOptions(Options options) {
        Option option = new Option(FLAG_TIMESTAMPS_PARAMETER, "timestamps", true, "List of timestamps (UTC timezone) to convert");
        option.setArgName("timestamp1 ... timestampN");
        option.setRequired(false);
        option.setArgs(-2);
        options.addOption(option);
    }

    @Override
    protected boolean readPropertiesFromCommandLine(CommandLine commandLine) {
        String[] timestampsStr = commandLine.getOptionValues(FLAG_TIMESTAMPS_PARAMETER);
        if (timestampsStr == null || timestampsStr.length == 0) {
            LOG.error("No timestamp passed as argument.");
            return false;
        }
        this.timestampsLong = new long[timestampsStr.length];
        for (int curIdx = 0; curIdx < timestampsStr.length; ++curIdx) {
            try {
                this.timestampsLong[curIdx] = Long.parseLong(timestampsStr[curIdx]);
                continue;
            }
            catch (NumberFormatException ex) {
                LOG.error("Failed to parse timestamp: " + timestampsStr[curIdx], ex);
                return false;
            }
        }
        return true;
    }

    @Override
    protected boolean performTask() {
        String lineSeperator = System.getProperty("line.separator");
        int estimatedNumberOfChars = this.timestampsLong.length * 85;
        StringBuilder stringBuilder = new StringBuilder(estimatedNumberOfChars);
        for (long timestampLong : this.timestampsLong) {
            stringBuilder.append(timestampLong).append(": ").append(LoggingTimestampConverter.convertLoggingTimestampToUTCString(timestampLong));
            stringBuilder.append(" (").append(LoggingTimestampConverter.convertLoggingTimestampLocalTimeZoneString(timestampLong)).append(')').append(lineSeperator);
        }
        System.out.print(stringBuilder.toString());
        return true;
    }
}

