/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.writer.filesystem;

import java.util.concurrent.BlockingQueue;
import kieker.common.configuration.Configuration;
import kieker.common.logging.Log;
import kieker.common.logging.LogFactory;
import kieker.common.record.IMonitoringRecord;
import kieker.monitoring.core.controller.IMonitoringController;
import kieker.monitoring.writer.filesystem.AbstractAsyncFSWriter;
import kieker.monitoring.writer.filesystem.async.AbstractFsWriterThread;
import kieker.monitoring.writer.filesystem.async.FsWriterThread;
import kieker.monitoring.writer.filesystem.map.MappingFileWriter;

public final class AsyncFsWriter
extends AbstractAsyncFSWriter {
    private static final String PREFIX = AsyncFsWriter.class.getName() + ".";
    public static final String CONFIG_FLUSH = PREFIX + "flush";
    public static final String CONFIG_BUFFER = PREFIX + "bufferSize";
    private static final Log LOG = LogFactory.getLog(AsyncFsWriter.class);
    private final int buffersize;
    private final boolean flush;

    public AsyncFsWriter(Configuration configuration) {
        super(configuration);
        int tmpBuffersize = configuration.getIntProperty(CONFIG_BUFFER);
        if (tmpBuffersize <= 0) {
            LOG.warn("Buffer size has to be greater than zero. Using 8192 instead.");
            tmpBuffersize = 8192;
        }
        this.buffersize = tmpBuffersize;
        this.flush = configuration.getBooleanProperty(CONFIG_FLUSH);
    }

    @Override
    protected Configuration getDefaultConfiguration() {
        Configuration configuration = new Configuration(super.getDefaultConfiguration());
        configuration.setProperty(CONFIG_BUFFER, "8192");
        configuration.setProperty(CONFIG_FLUSH, "true");
        return configuration;
    }

    @Override
    protected final AbstractFsWriterThread initWorker(IMonitoringController monitoringController, BlockingQueue<IMonitoringRecord> writeQueue, MappingFileWriter mappingFileWriter, String path, int maxEntiresInFile, int maxlogSize, int maxLogFiles) {
        return new FsWriterThread(monitoringController, writeQueue, mappingFileWriter, path, maxEntiresInFile, maxlogSize, maxLogFiles, this.flush, this.buffersize);
    }
}

