/*
 * Decompiled with CFR 0.152.
 */
package kieker.common.record.jvm;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import kieker.common.record.jvm.AbstractJVMRecord;
import kieker.common.util.registry.IRegistry;

public class GCRecord
extends AbstractJVMRecord {
    public static final int SIZE = 36;
    private static final long serialVersionUID = 6474827601195369151L;
    public static final Class<?>[] TYPES = new Class[]{Long.TYPE, String.class, String.class, String.class, Long.TYPE, Long.TYPE};
    private final String gcName;
    private final long collectionCount;
    private final long collectionTimeMS;

    public GCRecord(long timestamp, String hostname, String vmName, String gcName, long collectionCount, long collectionTimeMS) {
        super(timestamp, hostname, vmName);
        this.gcName = gcName == null ? "" : gcName;
        this.collectionCount = collectionCount;
        this.collectionTimeMS = collectionTimeMS;
    }

    public GCRecord(Object[] values) {
        super(values, TYPES);
        this.gcName = (String)values[3];
        this.collectionCount = (Long)values[4];
        this.collectionTimeMS = (Long)values[5];
    }

    protected GCRecord(Object[] values, Class<?>[] valueTypes) {
        super(values, valueTypes);
        this.gcName = (String)values[3];
        this.collectionCount = (Long)values[4];
        this.collectionTimeMS = (Long)values[5];
    }

    public GCRecord(ByteBuffer buffer, IRegistry<String> stringRegistry) throws BufferUnderflowException {
        super(buffer, stringRegistry);
        this.gcName = stringRegistry.get(buffer.getInt());
        this.collectionCount = buffer.getLong();
        this.collectionTimeMS = buffer.getLong();
    }

    @Override
    public Object[] toArray() {
        return new Object[]{this.getTimestamp(), this.getHostname(), this.getVmName(), this.getGcName(), this.getCollectionCount(), this.getCollectionTimeMS()};
    }

    @Override
    public void writeBytes(ByteBuffer buffer, IRegistry<String> stringRegistry) throws BufferOverflowException {
        buffer.putLong(this.getTimestamp());
        buffer.putInt(stringRegistry.get(this.getHostname()));
        buffer.putInt(stringRegistry.get(this.getVmName()));
        buffer.putInt(stringRegistry.get(this.getGcName()));
        buffer.putLong(this.getCollectionCount());
        buffer.putLong(this.getCollectionTimeMS());
    }

    @Override
    public Class<?>[] getValueTypes() {
        return TYPES;
    }

    @Override
    public int getSize() {
        return 36;
    }

    @Override
    @Deprecated
    public void initFromArray(Object[] values) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void initFromBytes(ByteBuffer buffer, IRegistry<String> stringRegistry) throws BufferUnderflowException {
        throw new UnsupportedOperationException();
    }

    public final String getGcName() {
        return this.gcName;
    }

    public final long getCollectionCount() {
        return this.collectionCount;
    }

    public final long getCollectionTimeMS() {
        return this.collectionTimeMS;
    }
}

