/*
 * Decompiled with CFR 0.152.
 */
package kieker.common.logging;

import java.util.logging.Level;
import java.util.logging.Logger;
import kieker.common.logging.Log;

public final class LogImplJDK14
implements Log {
    private final Logger logger;
    private final String name;

    protected LogImplJDK14(String name) {
        this.name = name;
        this.logger = Logger.getLogger(name);
    }

    private final void log(Level level, String message, Throwable t) {
        if (this.logger.isLoggable(level)) {
            String sourceClass = this.name;
            StackTraceElement[] stackArray = new Throwable().getStackTrace();
            String sourceMethod = stackArray.length > 2 ? stackArray[2].getMethodName() : "unknown";
            if (t != null) {
                this.logger.logp(level, sourceClass, sourceMethod, message, t);
            } else {
                this.logger.logp(level, sourceClass, sourceMethod, message);
            }
        }
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isLoggable(Level.FINER);
    }

    @Override
    public void trace(String message) {
        this.log(Level.FINER, message, null);
    }

    @Override
    public void trace(String message, Throwable t) {
        this.log(Level.FINER, message, t);
    }

    @Override
    public final boolean isDebugEnabled() {
        return this.logger.isLoggable(Level.FINE);
    }

    @Override
    public final void debug(String message) {
        this.log(Level.FINE, message, null);
    }

    @Override
    public final void debug(String message, Throwable t) {
        this.log(Level.FINE, message, t);
    }

    @Override
    public final void info(String message) {
        this.log(Level.INFO, message, null);
    }

    @Override
    public final void info(String message, Throwable t) {
        this.log(Level.INFO, message, t);
    }

    @Override
    public final void warn(String message) {
        this.log(Level.WARNING, message, null);
    }

    @Override
    public final void warn(String message, Throwable t) {
        this.log(Level.WARNING, message, t);
    }

    @Override
    public final void error(String message) {
        this.log(Level.SEVERE, message, null);
    }

    @Override
    public final void error(String message, Throwable t) {
        this.log(Level.SEVERE, message, t);
    }
}

