/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.vfs;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import net.sourceforge.stripes.util.Log;
import net.sourceforge.stripes.util.StringUtil;
import net.sourceforge.stripes.vfs.VFS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultVFS
extends VFS {
    private Log log = Log.getInstance(DefaultVFS.class);
    private static final byte[] JAR_MAGIC = new byte[]{80, 75, 3, 4};

    @Override
    public boolean isValid() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> list(URL url, String path) throws IOException {
        InputStream is = null;
        try {
            ArrayList<String> resources = new ArrayList();
            URL jarUrl = this.findJarForResource(url);
            if (jarUrl != null) {
                is = jarUrl.openStream();
                this.log.debug("Listing ", url);
                resources = this.listResources(new JarInputStream(is), path);
            } else {
                List<String> children = new ArrayList<String>();
                try {
                    if (this.isJar(url)) {
                        JarEntry entry;
                        is = url.openStream();
                        JarInputStream jarInput = new JarInputStream(is);
                        this.log.debug("Listing ", url);
                        while ((entry = jarInput.getNextJarEntry()) != null) {
                            this.log.trace("Jar entry: ", entry.getName());
                            children.add(entry.getName());
                        }
                    } else {
                        String line;
                        is = url.openStream();
                        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
                        ArrayList<String> lines = new ArrayList<String>();
                        while ((line = reader.readLine()) != null) {
                            this.log.trace("Reader entry: ", line);
                            lines.add(line);
                            if (!DefaultVFS.getResources(path + "/" + line).isEmpty()) continue;
                            lines.clear();
                            break;
                        }
                        if (!lines.isEmpty()) {
                            this.log.debug("Listing ", url);
                            children.addAll(lines);
                        }
                    }
                }
                catch (FileNotFoundException e) {
                    if ("file".equals(url.getProtocol())) {
                        File file = new File(url.getFile());
                        this.log.trace("Listing directory ", file.getAbsolutePath());
                        if (file.isDirectory()) {
                            this.log.debug("Listing ", url);
                            children = Arrays.asList(file.list());
                        }
                    }
                    throw e;
                }
                String prefix = url.toExternalForm();
                if (!prefix.endsWith("/")) {
                    prefix = prefix + "/";
                }
                for (String child : children) {
                    String resourcePath = path + "/" + child;
                    resources.add(resourcePath);
                    URL childUrl = new URL(prefix + child);
                    resources.addAll(this.list(childUrl, resourcePath));
                }
            }
            ArrayList<String> arrayList = resources;
            return arrayList;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception e) {}
        }
    }

    protected List<String> listResources(JarInputStream jar, String path) throws IOException {
        JarEntry entry;
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        ArrayList<String> resources = new ArrayList<String>();
        while ((entry = jar.getNextJarEntry()) != null) {
            if (entry.isDirectory()) continue;
            String name = entry.getName();
            if (!name.startsWith("/")) {
                name = "/" + name;
            }
            if (!name.startsWith(path)) continue;
            this.log.trace("Found resource: ", name);
            resources.add(name.substring(1));
        }
        return resources;
    }

    protected URL findJarForResource(URL url) throws MalformedURLException {
        this.log.trace("Find JAR URL: ", url);
        try {
            while (true) {
                url = new URL(url.getFile());
                this.log.trace("Inner URL: ", url);
            }
        }
        catch (MalformedURLException e) {
            StringBuilder jarUrl = new StringBuilder(url.toExternalForm());
            int index = jarUrl.lastIndexOf(".jar");
            if (index < 0) {
                this.log.trace("Not a JAR: ", jarUrl);
                return null;
            }
            jarUrl.setLength(index + 4);
            this.log.trace("Extracted JAR URL: ", jarUrl);
            try {
                URL testUrl = new URL(jarUrl.toString());
                if (this.isJar(testUrl)) {
                    return testUrl;
                }
                this.log.trace("Not a JAR: ", jarUrl);
                jarUrl.replace(0, jarUrl.length(), testUrl.getFile());
                File file = new File(jarUrl.toString());
                if (!file.exists()) {
                    file = new File(StringUtil.urlDecode(jarUrl.toString()));
                }
                if (file.exists()) {
                    this.log.trace("Trying real file: ", file.getAbsolutePath());
                    testUrl = file.toURI().toURL();
                    if (this.isJar(testUrl)) {
                        return testUrl;
                    }
                }
            }
            catch (MalformedURLException e2) {
                this.log.warn("Invalid JAR URL: ", jarUrl);
            }
            this.log.trace("Not a JAR: ", jarUrl);
            return null;
        }
    }

    protected String getPackagePath(String packageName) {
        return packageName == null ? null : packageName.replace('.', '/');
    }

    protected boolean isJar(URL url) {
        return this.isJar(url, new byte[JAR_MAGIC.length]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isJar(URL url, byte[] buffer) {
        InputStream is = null;
        try {
            is = url.openStream();
            is.read(buffer, 0, JAR_MAGIC.length);
            if (Arrays.equals(buffer, JAR_MAGIC)) {
                this.log.debug("Found JAR: ", url);
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
        }
        finally {
            try {
                is.close();
            }
            catch (Exception e) {}
        }
        return false;
    }
}

