/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.stripes.exception.StripesRuntimeException;
import net.sourceforge.stripes.util.CollectionUtil;

public class StringUtil {
    private static final Pattern STANDARD_SPLIT = Pattern.compile("[\\s,]+");
    private static final Pattern URI_FRAGMENT_DISALLOWED_CHARACTERS = Pattern.compile("[^\\p{Alnum}._~!$&'()*+,;=:@/?-]");

    public static String[] standardSplit(String input) {
        if (input == null) {
            return new String[0];
        }
        return STANDARD_SPLIT.split(input.trim());
    }

    public static String combineParts(Object ... messageParts) {
        StringBuilder builder = new StringBuilder(128);
        for (Object part : messageParts) {
            if (part != null && part.getClass().isArray()) {
                builder.append(Arrays.toString(CollectionUtil.asObjectArray(part)));
                continue;
            }
            builder.append(part);
        }
        return builder.toString();
    }

    public static String urlEncode(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new StripesRuntimeException("Unsupported encoding?  UTF-8?  That's unpossible.");
        }
    }

    public static String urlDecode(String value) {
        try {
            return URLDecoder.decode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new StripesRuntimeException("Unsupported encoding?  UTF-8?  That's unpossible.");
        }
    }

    public static String uriFragmentEncode(String value) {
        Matcher matcher = URI_FRAGMENT_DISALLOWED_CHARACTERS.matcher(value);
        StringBuilder buf = null;
        int end = 0;
        while (matcher.find()) {
            if (buf == null) {
                buf = new StringBuilder(value.length() * 2);
            }
            buf.append(value.substring(end, matcher.start())).append(String.format("%%%02X", matcher.group().charAt(0)));
            end = matcher.end();
        }
        if (buf == null) {
            return value;
        }
        if (end < value.length()) {
            buf.append(value.substring(end));
        }
        return buf.toString();
    }

    public static String trimFragment(String url) {
        if (url == null || url.length() < 1) {
            return url;
        }
        int index = url.indexOf(35);
        if (index >= 0) {
            return url.substring(0, index);
        }
        return url;
    }
}

