/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Range<T extends Comparable<T>>
implements Comparable<Range<T>> {
    private T start;
    private T end;

    public Range(T start, T end) {
        this.setStart(start);
        this.setEnd(end);
    }

    public T getStart() {
        return this.start;
    }

    public void setStart(T start) {
        if (start == null) {
            throw new NullPointerException();
        }
        this.start = start;
    }

    public T getEnd() {
        return this.end;
    }

    public void setEnd(T end) {
        if (end == null) {
            throw new NullPointerException();
        }
        this.end = end;
    }

    public boolean contains(T item) {
        return this.start.compareTo(item) <= 0 && this.end.compareTo(item) >= 0;
    }

    @Override
    public int compareTo(Range<T> o) {
        int res = this.start.compareTo(o.getStart());
        if (res == 0) {
            res = this.end.compareTo(o.getEnd());
        }
        return res;
    }

    public boolean equals(Object o) {
        return o instanceof Range && (this == o || this.compareTo((Range)o) == 0);
    }

    public int hashCode() {
        return this.start.hashCode() ^ this.end.hashCode();
    }

    public String toString() {
        return this.getClass().getName() + " { type: " + this.start.getClass().getName() + ", start: " + this.start.toString() + ", end: " + this.end.toString() + " }";
    }
}

