/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.tag.layout;

import java.io.IOException;
import java.util.regex.Pattern;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import net.sourceforge.stripes.exception.StripesJspException;
import net.sourceforge.stripes.exception.StripesRuntimeException;
import net.sourceforge.stripes.tag.layout.LayoutComponentRenderer;
import net.sourceforge.stripes.tag.layout.LayoutContext;
import net.sourceforge.stripes.tag.layout.LayoutRenderTag;
import net.sourceforge.stripes.tag.layout.LayoutRenderTagPath;
import net.sourceforge.stripes.tag.layout.LayoutTag;
import net.sourceforge.stripes.util.Log;

public class LayoutComponentTag
extends LayoutTag {
    private static final Log log = Log.getInstance(LayoutComponentTag.class);
    private static final Pattern javaIdentifierPattern = Pattern.compile("\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*");
    private String name;
    private LayoutContext context;
    private boolean silent;
    private Boolean componentRenderPhase;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPageContext(PageContext pageContext) {
        super.setPageContext(pageContext);
        this.context = LayoutContext.lookup(pageContext);
        if (this.context == null) {
            throw new StripesRuntimeException("A component tag named \"" + this.getName() + "\" in " + this.getCurrentPagePath() + " was unable to find a layout context.");
        }
        log.trace("Component ", this.getName() + " has context ", this.context.getRenderPage(), " -> ", this.context.getDefinitionPage());
        this.silent = this.context.getOut().isSilent();
    }

    public boolean isCurrentComponent() throws StripesJspException {
        String name = this.context.getComponent();
        if (name == null || !name.equals(this.getName())) {
            return false;
        }
        Object parent = this.getLayoutParent();
        if (!(parent instanceof LayoutRenderTag)) {
            return this.context.getComponentPath().getComponentPath() == null;
        }
        LayoutRenderTagPath got = ((LayoutRenderTag)parent).getPath();
        return got != null && got.equals(this.context.getComponentPath());
    }

    public int doStartTag() throws JspException {
        try {
            if (this.context.isComponentRenderPhase()) {
                if (this.isChildOfRender()) {
                    if (this.isCurrentComponent()) {
                        log.debug("Render ", this.getName(), " in ", this.context.getRenderPage());
                        this.context.getOut().setSilent(false, this.pageContext);
                        return 1;
                    }
                    if (this.context.getComponentPath().isPathComponent(this)) {
                        log.debug("Silently execute '", this.getName(), "' in ", this.context.getRenderPage());
                        this.context.getOut().setSilent(true, this.pageContext);
                        return 1;
                    }
                    log.debug("No-op for ", this.getName(), " in ", this.context.getRenderPage());
                } else if (this.isChildOfDefinition()) {
                    log.debug("No-op for ", this.getName(), " in ", this.context.getDefinitionPage());
                } else if (this.isChildOfComponent()) {
                    boolean rendered;
                    log.debug("Invoke component renderer for nested render of \"", this.getName(), "\"");
                    LayoutComponentRenderer renderer = (LayoutComponentRenderer)this.pageContext.getAttribute(this.getName());
                    if (renderer == null) {
                        log.debug("No component renderer in page context for '" + this.getName() + "'");
                    }
                    boolean bl = rendered = renderer != null && renderer.write();
                    if (!rendered) {
                        log.debug("Component was not present in ", this.context.getRenderPage(), " so using default content from ", this.context.getDefinitionPage());
                        this.context.getOut().setSilent(false, this.pageContext);
                        return 1;
                    }
                }
            } else if (this.isChildOfRender()) {
                if (!javaIdentifierPattern.matcher(this.getName()).matches()) {
                    log.warn("The layout-component name '", this.getName(), "' is not a valid Java identifier. While this may work, it can ", "cause bugs that are difficult to track down. Please consider ", "using valid Java identifiers for component names ", "(no hyphens, no spaces, etc.)");
                }
                log.debug("Register component ", this.getName(), " with ", this.context.getRenderPage());
                LayoutComponentRenderer renderer = null;
                for (LayoutContext c = this.context; c != null && renderer == null; c = c.getPrevious()) {
                    renderer = c.getComponents().get(this.getName());
                }
                if (renderer == null) {
                    renderer = new LayoutComponentRenderer(this.getName());
                }
                this.context.getComponents().put(this.getName(), renderer);
            } else if (this.isChildOfDefinition()) {
                boolean rendered;
                log.debug("Invoke component renderer for direct render of \"", this.getName(), "\"");
                LayoutComponentRenderer renderer = (LayoutComponentRenderer)this.pageContext.getAttribute(this.getName());
                if (renderer == null) {
                    log.debug("No component renderer in page context for '" + this.getName() + "'");
                }
                boolean bl = rendered = renderer != null && renderer.write();
                if (!rendered) {
                    log.debug("Component was not present in ", this.context.getRenderPage(), " so using default content from ", this.context.getDefinitionPage());
                    this.componentRenderPhase = this.context.isComponentRenderPhase();
                    this.context.setComponentRenderPhase(true);
                    this.context.setComponent(this.getName());
                    this.context.getOut().setSilent(false, this.pageContext);
                    return 1;
                }
            } else if (this.isChildOfComponent()) {
                // empty if block
            }
            this.context.getOut().setSilent(true, this.pageContext);
            return 0;
        }
        catch (Exception e) {
            log.error(e, "Unhandled exception trying to render component \"", this.getName(), "\" to a string in context ", this.context.getRenderPage(), " -> ", this.context.getDefinitionPage());
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new StripesJspException(e);
        }
    }

    public int doEndTag() throws JspException {
        try {
            if (this.isCurrentComponent()) {
                this.context.setComponent(null);
            }
            if (this.componentRenderPhase != null) {
                this.context.setComponentRenderPhase(this.componentRenderPhase);
            }
            this.context.getOut().setSilent(this.silent, this.pageContext);
            int n = 6;
            return n;
        }
        catch (IOException e) {
            throw new JspException((Throwable)e);
        }
        finally {
            this.context = null;
            this.silent = false;
            this.componentRenderPhase = null;
        }
    }
}

