/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.tag;

import java.io.IOException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyTag;
import net.sourceforge.stripes.exception.StripesJspException;
import net.sourceforge.stripes.localization.LocalizationUtility;
import net.sourceforge.stripes.tag.InputTagSupport;

public class InputLabelTag
extends InputTagSupport
implements BodyTag {
    private boolean nameSet;

    public void setFor(String forId) {
        this.set("for", forId);
        if (!this.nameSet) {
            super.setName(forId);
        }
    }

    public String getFor() {
        return this.get("for");
    }

    public void setName(String name) {
        super.setName(name);
        this.nameSet = true;
    }

    public int doStartInputTag() throws JspException {
        return 2;
    }

    public void doInitBody() throws JspException {
    }

    public int doAfterBody() throws JspException {
        return 0;
    }

    public int doEndInputTag() throws JspException {
        try {
            String label = this.getLocalizedFieldName();
            String fieldName = this.getAttributes().remove("name");
            if (label == null) {
                label = this.getBodyContentAsString();
            }
            if (label == null) {
                label = fieldName != null ? LocalizationUtility.makePseudoFriendlyName(fieldName) : "Label could not find localized field name and had no body nor name attribute.";
            }
            this.writeOpenTag(this.getPageContext().getOut(), "label");
            this.getPageContext().getOut().write(label);
            this.writeCloseTag(this.getPageContext().getOut(), "label");
            if (this.nameSet) {
                super.setName(fieldName);
            }
            return 6;
        }
        catch (IOException ioe) {
            throw new StripesJspException("Encountered an exception while trying to write to the output from the stripes:label tag handler class, InputLabelTag.", ioe);
        }
    }

    protected void registerWithParentForm() throws StripesJspException {
    }

    protected void loadErrors() {
        try {
            super.loadErrors();
        }
        catch (StripesJspException stripesJspException) {
            // empty catch block
        }
    }
}

