/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.mock;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import net.sourceforge.stripes.mock.MockFilterChain;
import net.sourceforge.stripes.mock.MockFilterConfig;
import net.sourceforge.stripes.mock.MockHttpServletRequest;
import net.sourceforge.stripes.mock.MockHttpServletResponse;
import net.sourceforge.stripes.mock.MockRequestDispatcher;
import net.sourceforge.stripes.mock.MockServletConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockServletContext
implements ServletContext {
    private String contextName;
    private Map<String, String> initParameters = new HashMap<String, String>();
    private Map<String, Object> attributes = new HashMap<String, Object>();
    private List<Filter> filters = new ArrayList<Filter>();
    private HttpServlet servlet;

    public MockServletContext(String contextName) {
        this.contextName = contextName;
    }

    public ServletContext getContext(String url) {
        if (url.startsWith("/" + this.contextName)) {
            return this;
        }
        return null;
    }

    public String getContextPath() {
        return "/" + this.contextName;
    }

    public int getMajorVersion() {
        return 2;
    }

    public int getMinorVersion() {
        return 4;
    }

    public String getMimeType(String file) {
        return null;
    }

    public Set<?> getResourcePaths(String path) {
        return null;
    }

    public URL getResource(String name) throws MalformedURLException {
        while (name.startsWith("/")) {
            name = name.substring(1);
        }
        return Thread.currentThread().getContextClassLoader().getResource(name);
    }

    public InputStream getResourceAsStream(String name) {
        while (name.startsWith("/")) {
            name = name.substring(1);
        }
        return Thread.currentThread().getContextClassLoader().getResourceAsStream(name);
    }

    public RequestDispatcher getRequestDispatcher(String url) {
        return new MockRequestDispatcher(url);
    }

    public RequestDispatcher getNamedDispatcher(String name) {
        return new MockRequestDispatcher(name);
    }

    public Servlet getServlet(String string) throws ServletException {
        return null;
    }

    public Enumeration<?> getServlets() {
        return Collections.enumeration(Collections.emptySet());
    }

    public Enumeration<?> getServletNames() {
        return Collections.enumeration(Collections.emptySet());
    }

    public void log(String message) {
        System.out.println("MockServletContext: " + message);
    }

    public void log(Exception exception, String message) {
        this.log(message, exception);
    }

    public void log(String message, Throwable throwable) {
        this.log(message);
        throwable.printStackTrace(System.out);
    }

    public String getRealPath(String string) {
        return null;
    }

    public String getServerInfo() {
        return "Stripes Mock Servlet Environment, version 1.0.";
    }

    public void addInitParameter(String name, String value) {
        this.initParameters.put(name, value);
    }

    public void addAllInitParameters(Map<String, String> parameters) {
        this.initParameters.putAll(parameters);
    }

    public String getInitParameter(String name) {
        return this.initParameters.get(name);
    }

    public Enumeration<String> getInitParameterNames() {
        return Collections.enumeration(this.initParameters.keySet());
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Enumeration<String> getAttributeNames() {
        return Collections.enumeration(this.attributes.keySet());
    }

    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public String getServletContextName() {
        return this.contextName;
    }

    public void addFilter(Class<? extends Filter> filterClass, String filterName, Map<String, String> initParams) {
        try {
            MockFilterConfig config = new MockFilterConfig();
            config.setFilterName(filterName);
            config.setServletContext(this);
            if (initParams != null) {
                config.addAllInitParameters(initParams);
            }
            Filter filter = filterClass.newInstance();
            filter.init((FilterConfig)config);
            this.filters.add(filter);
        }
        catch (Exception e) {
            throw new RuntimeException("Exception registering new filter with name " + filterName, e);
        }
    }

    public List<Filter> getFilters() {
        return this.filters;
    }

    public void setServlet(Class<? extends HttpServlet> servletClass, String servletName, Map<String, String> initParams) {
        try {
            MockServletConfig config = new MockServletConfig();
            config.setServletName(servletName);
            config.setServletContext(this);
            if (initParams != null) {
                config.addAllInitParameters(initParams);
            }
            this.servlet = servletClass.newInstance();
            this.servlet.init((ServletConfig)config);
        }
        catch (Exception e) {
            throw new RuntimeException("Exception registering servlet with name " + servletName, e);
        }
    }

    public void acceptRequest(MockHttpServletRequest request, MockHttpServletResponse response) throws Exception {
        this.copyCookies(request, response);
        MockFilterChain chain = new MockFilterChain();
        chain.setServlet((Servlet)this.servlet);
        chain.addFilters(this.filters);
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public void copyCookies(MockHttpServletRequest request, MockHttpServletResponse response) {
        if (request.getCookies() != null) {
            for (Cookie cookie : request.getCookies()) {
                response.addCookie(cookie);
            }
        }
    }
}

