/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.localization;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.config.Configuration;
import net.sourceforge.stripes.controller.ParameterName;
import net.sourceforge.stripes.controller.StripesFilter;
import net.sourceforge.stripes.util.Log;
import net.sourceforge.stripes.validation.ValidationMetadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalizationUtility {
    private static final Log log = Log.getInstance(LocalizationUtility.class);

    public static String getLocalizedFieldName(String fieldName, String actionPath, Class<? extends ActionBean> beanclass, Locale locale) {
        ValidationMetadata validate;
        ParameterName parameterName = new ParameterName(fieldName);
        String strippedName = parameterName.getStrippedName();
        String localizedValue = null;
        ResourceBundle bundle = null;
        try {
            bundle = StripesFilter.getConfiguration().getLocalizationBundleFactory().getFormFieldBundle(locale);
        }
        catch (MissingResourceException mre) {
            log.error(mre, new Object[0]);
            return null;
        }
        if (beanclass != null) {
            try {
                localizedValue = bundle.getString(beanclass.getName() + "." + strippedName);
            }
            catch (MissingResourceException mre) {
                // empty catch block
            }
        }
        if (localizedValue == null) {
            try {
                localizedValue = bundle.getString(actionPath + "." + strippedName);
            }
            catch (MissingResourceException mre) {
                // empty catch block
            }
        }
        if (localizedValue == null) {
            try {
                localizedValue = bundle.getString(strippedName);
            }
            catch (MissingResourceException mre2) {
                // empty catch block
            }
        }
        if (localizedValue == null && beanclass != null && (validate = StripesFilter.getConfiguration().getValidationMetadataProvider().getValidationMetadata(beanclass, parameterName)) != null && validate.label() != null && !"".equals(validate.label())) {
            localizedValue = validate.label();
        }
        return localizedValue;
    }

    public static String makePseudoFriendlyName(String fieldNameKey) {
        StringBuilder builder = new StringBuilder(fieldNameKey.length() + 10);
        char[] characters = fieldNameKey.toCharArray();
        builder.append(Character.toUpperCase(characters[0]));
        boolean upcaseNextChar = false;
        for (int i = 1; i < characters.length; ++i) {
            if (characters[i] == '.') {
                builder.append(' ');
                upcaseNextChar = true;
                continue;
            }
            if (Character.isUpperCase(characters[i])) {
                builder.append(' ').append(characters[i]);
                upcaseNextChar = false;
                continue;
            }
            if (upcaseNextChar) {
                builder.append(Character.toUpperCase(characters[i]));
                upcaseNextChar = false;
                continue;
            }
            builder.append(characters[i]);
            upcaseNextChar = false;
        }
        return builder.toString();
    }

    public static String getErrorMessage(Locale locale, String key) {
        try {
            Configuration config = StripesFilter.getConfiguration();
            ResourceBundle bundle = config.getLocalizationBundleFactory().getErrorMessageBundle(locale);
            return bundle.getString(key);
        }
        catch (MissingResourceException mre) {
            return null;
        }
    }

    public static String getSimpleName(Class<?> c) {
        if (c.getEnclosingClass() == null) {
            return c.getSimpleName();
        }
        return LocalizationUtility.prefixSimpleName(new StringBuilder(), c).toString();
    }

    private static StringBuilder prefixSimpleName(StringBuilder s, Class<?> c) {
        if (c.getEnclosingClass() != null) {
            LocalizationUtility.prefixSimpleName(s, c.getEnclosingClass()).append('.');
        }
        return s.append(c.getSimpleName());
    }
}

