/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.exception;

import java.util.Collection;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.exception.StripesRuntimeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UrlBindingConflictException
extends StripesRuntimeException {
    private static final long serialVersionUID = 1L;
    private String path;
    private Collection<String> matches;
    private Class<? extends ActionBean> targetClass;

    protected static String getMessage(Class<? extends ActionBean> targetClass, String path, Collection<String> matches) {
        return (targetClass == null ? "" : "Failure generating URL for " + targetClass + ". ") + "The path " + path + " cannot be mapped to a single ActionBean because multiple " + "URL bindings match it. The matching URL bindings are " + matches + ". If you " + "generated the URL using the Stripes tag library (stripes:link, stripes:url, " + "stripes:form, etc.) then you must embed enough stripes:param tags within the " + "parent tag to produce a URL that maps to exactly one of the indicated matches. " + "If you generated the URL by some other means, then you must embed enough " + "information in the URL to achieve the same end.";
    }

    public UrlBindingConflictException(String message, Class<? extends ActionBean> targetClass, String path, Collection<String> matches) {
        super(message);
        this.targetClass = targetClass;
        this.path = path;
        this.matches = matches;
    }

    public UrlBindingConflictException(Class<? extends ActionBean> targetClass, String path, Collection<String> matches) {
        this(UrlBindingConflictException.getMessage(targetClass, path, matches), targetClass, path, matches);
    }

    public UrlBindingConflictException(String message, String path, Collection<String> matches) {
        this(message, null, path, matches);
    }

    public UrlBindingConflictException(String path, Collection<String> matches) {
        this(UrlBindingConflictException.getMessage(null, path, matches), path, matches);
    }

    public String getPath() {
        return this.path;
    }

    public Collection<String> getMatches() {
        return this.matches;
    }

    public Class<? extends ActionBean> getTargetClass() {
        return this.targetClass;
    }
}

