/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.controller;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.controller.UrlBinding;
import net.sourceforge.stripes.controller.UrlBindingParameter;
import net.sourceforge.stripes.exception.StripesRuntimeException;
import net.sourceforge.stripes.exception.UrlBindingConflictException;
import net.sourceforge.stripes.util.HttpUtil;
import net.sourceforge.stripes.util.Log;
import net.sourceforge.stripes.util.bean.ParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UrlBindingFactory {
    private static final Log log = Log.getInstance(UrlBindingFactory.class);
    private final Map<Class<? extends ActionBean>, UrlBinding> classCache = new HashMap<Class<? extends ActionBean>, UrlBinding>();
    private final Map<String, UrlBinding> pathCache = new HashMap<String, UrlBinding>();
    private final Map<String, List<UrlBinding>> pathConflicts = new HashMap<String, List<UrlBinding>>();
    private final Map<String, Set<UrlBinding>> prefixCache = new TreeMap<String, Set<UrlBinding>>(new Comparator<String>(){

        @Override
        public int compare(String a, String b) {
            int cmp = b.length() - a.length();
            return cmp == 0 ? a.compareTo(b) : cmp;
        }
    });

    public Collection<Class<? extends ActionBean>> getActionBeanClasses() {
        return Collections.unmodifiableSet(this.classCache.keySet());
    }

    public UrlBinding getBindingPrototype(Class<? extends ActionBean> type) {
        UrlBinding binding = this.classCache.get(type);
        if (binding != null) {
            return binding;
        }
        binding = UrlBindingFactory.parseUrlBinding(type);
        if (binding != null) {
            this.addBinding(type, binding);
        }
        return binding;
    }

    public UrlBinding getBindingPrototype(String uri) {
        UrlBinding prototype = this.pathCache.get(uri);
        if (prototype != null) {
            log.debug("Matched ", uri, " to ", prototype);
            return prototype;
        }
        if (this.pathConflicts.containsKey(uri)) {
            ArrayList<String> strings = new ArrayList<String>();
            for (UrlBinding conflict : this.pathConflicts.get(uri)) {
                strings.add(conflict.toString());
            }
            throw new UrlBindingConflictException(uri, strings);
        }
        Set<UrlBinding> candidates = null;
        for (Map.Entry<String, Set<UrlBinding>> entry : this.prefixCache.entrySet()) {
            if (!uri.startsWith(entry.getKey())) continue;
            candidates = entry.getValue();
            break;
        }
        if (candidates == null) {
            log.debug("No URL binding matches ", uri);
            return null;
        }
        if (candidates.size() == 1) {
            log.debug("Matched ", uri, " to ", candidates);
            return candidates.iterator().next();
        }
        int maxIndex = 0;
        int minComponentCount = Integer.MAX_VALUE;
        int maxComponentMatch = 0;
        Object conflicts = null;
        for (UrlBinding binding : candidates) {
            boolean betterMatch;
            int idx = binding.getPath().length();
            List<Object> components = binding.getComponents();
            int componentCount = components.size();
            int componentMatch = 0;
            for (Object component : components) {
                if (!(component instanceof String)) continue;
                String string = (String)component;
                int at = uri.indexOf(string, idx);
                if (at >= 0) {
                    idx = at + string.length();
                    ++componentMatch;
                    continue;
                }
                if (binding.getSuffix() == null || (at = uri.indexOf(string = binding.getSuffix(), idx)) < 0) break;
                idx = at + string.length();
                ++componentMatch;
                break;
            }
            boolean bl = betterMatch = idx > maxIndex || idx == maxIndex && (componentCount < minComponentCount || componentMatch > maxComponentMatch);
            if (betterMatch) {
                if (conflicts != null) {
                    conflicts.clear();
                }
                prototype = binding;
                maxIndex = idx;
                minComponentCount = componentCount;
                maxComponentMatch = componentMatch;
                continue;
            }
            if (idx != maxIndex || componentCount != minComponentCount) continue;
            if (conflicts == null) {
                conflicts = new ArrayList(candidates.size());
                conflicts.add(prototype.toString());
            }
            conflicts.add(binding.toString());
            prototype = null;
        }
        log.debug("Matched @", maxIndex, " ", uri, " to ", prototype == null ? conflicts : prototype);
        if (prototype == null) {
            throw new UrlBindingConflictException(uri, (Collection<String>)conflicts);
        }
        return prototype;
    }

    public UrlBinding getBindingPrototype(HttpServletRequest request) {
        return this.getBindingPrototype(HttpUtil.getRequestedPath(request));
    }

    public UrlBinding getBinding(String uri) {
        Object component;
        UrlBinding prototype = this.getBindingPrototype(uri);
        if (prototype == null) {
            return null;
        }
        int length = uri.length();
        String suffix = prototype.getSuffix();
        if (suffix != null && uri.endsWith(suffix)) {
            length -= suffix.length();
        }
        while (length > 0 && uri.charAt(length - 1) == '/') {
            --length;
        }
        ArrayList<Object> components = new ArrayList<Object>(prototype.getComponents().size());
        int index = prototype.getPath().length();
        UrlBindingParameter current = null;
        String value = null;
        Iterator<Object> iter = prototype.getComponents().iterator();
        while (index < length && iter.hasNext()) {
            component = iter.next();
            if (component instanceof String) {
                String literal = (String)component;
                int end = uri.indexOf(literal, index);
                if (end >= 0) {
                    value = uri.substring(index, end);
                    index = end + literal.length();
                } else {
                    value = uri.substring(index, length);
                    index = length;
                }
                if (current == null || value == null || value.length() <= 0) continue;
                components.add(new UrlBindingParameter(current, value));
                components.add(component);
                current = null;
                value = null;
                continue;
            }
            if (!(component instanceof UrlBindingParameter)) continue;
            current = (UrlBindingParameter)component;
        }
        if (index < length) {
            value = uri.substring(index, length);
        }
        if (current != null && value != null && value.length() > 0) {
            components.add(new UrlBindingParameter(current, value));
        }
        while (iter.hasNext()) {
            component = iter.next();
            if (component instanceof UrlBindingParameter) {
                components.add(new UrlBindingParameter((UrlBindingParameter)component));
                continue;
            }
            components.add(component);
        }
        return new UrlBinding(prototype.getBeanType(), prototype.getPath(), components);
    }

    public UrlBinding getBinding(HttpServletRequest request) {
        return this.getBinding(HttpUtil.getRequestedPath(request));
    }

    public HashMap<String, Class<? extends ActionBean>> getPathMap() {
        HashMap<String, Class<? extends ActionBean>> map = new HashMap<String, Class<? extends ActionBean>>();
        for (Map.Entry<String, UrlBinding> entry : this.pathCache.entrySet()) {
            if (entry.getValue() == null) continue;
            map.put(entry.getKey(), entry.getValue().getBeanType());
        }
        return map;
    }

    public void addBinding(Class<? extends ActionBean> beanType, UrlBinding binding) {
        Class<? extends ActionBean> existing = null;
        for (Class<? extends ActionBean> c : this.classCache.keySet()) {
            if (!c.getName().equals(beanType.getName())) continue;
            existing = c;
            break;
        }
        if (existing != null) {
            this.removeBinding(existing);
        }
        for (String path : this.getCachedPaths(binding)) {
            this.cachePath(path, binding);
        }
        for (String prefix : this.getCachedPrefixes(binding)) {
            this.cachePrefix(prefix, binding);
        }
        this.classCache.put(beanType, binding);
    }

    public synchronized void removeBinding(Class<? extends ActionBean> beanType) {
        UrlBinding binding = this.classCache.get(beanType);
        if (binding == null) {
            return;
        }
        LinkedHashSet<UrlBinding> resolvedConflicts = null;
        for (String path : this.getCachedPaths(binding)) {
            log.debug("Clearing cached path ", path, " for ", binding);
            this.pathCache.remove(path);
            List<UrlBinding> conflicts = this.pathConflicts.get(path);
            if (conflicts == null) continue;
            log.debug("Removing ", binding, " from conflicts list ", conflicts);
            conflicts.remove(binding);
            if (conflicts.size() == 1) {
                if (resolvedConflicts == null) {
                    resolvedConflicts = new LinkedHashSet<UrlBinding>();
                }
                resolvedConflicts.add(this.pathCache.get(conflicts.get(0)));
                conflicts.clear();
            }
            if (!conflicts.isEmpty()) continue;
            this.pathConflicts.remove(path);
        }
        for (String prefix : this.getCachedPrefixes(binding)) {
            Set<UrlBinding> bindings = this.prefixCache.get(prefix);
            if (bindings == null) continue;
            log.debug("Clearing cached prefix ", prefix, " for ", binding);
            bindings.remove(binding);
            if (!bindings.isEmpty()) continue;
            this.prefixCache.remove(prefix);
        }
        this.classCache.remove(beanType);
        if (resolvedConflicts != null) {
            log.debug("Resolved conflicts with ", resolvedConflicts);
            for (UrlBinding conflict : resolvedConflicts) {
                this.removeBinding(conflict.getBeanType());
                this.addBinding(conflict.getBeanType(), conflict);
            }
        }
    }

    protected Set<String> getCachedPaths(UrlBinding binding) {
        TreeSet<String> paths = new TreeSet<String>();
        paths.add(binding.getPath());
        paths.add(binding.toString());
        if (!binding.getPath().endsWith("/")) {
            paths.add(binding.getPath() + '/');
        }
        if (binding.getSuffix() != null) {
            paths.add(binding.getPath() + binding.getSuffix());
        }
        return paths;
    }

    protected Set<String> getCachedPrefixes(UrlBinding binding) {
        TreeSet<String> prefixes = new TreeSet<String>();
        if (binding.getPath().endsWith("/")) {
            prefixes.add(binding.getPath());
        } else {
            prefixes.add(binding.getPath() + '/');
        }
        List<Object> components = binding.getComponents();
        if (components != null && !components.isEmpty() && components.get(0) instanceof String) {
            prefixes.add(binding.getPath() + components.get(0));
        }
        return prefixes;
    }

    protected void cachePath(String path, UrlBinding binding) {
        if (this.pathCache.containsKey(path)) {
            UrlBinding conflict = this.pathCache.put(path, null);
            List<UrlBinding> conflicts = this.pathConflicts.get(path);
            if (conflicts == null) {
                conflicts = new ArrayList<UrlBinding>();
                conflicts.add(conflict);
                this.pathConflicts.put(path, conflicts);
            }
            conflicts.add(binding);
            UrlBinding statik = null;
            if (conflicts.size() > 1) {
                for (UrlBinding ub : conflicts) {
                    if (!ub.getParameters().isEmpty()) continue;
                    if (statik == null) {
                        statik = ub;
                        continue;
                    }
                    statik = null;
                    break;
                }
            }
            if (statik == null) {
                log.debug("The path ", path, " for ", binding.getBeanType().getName(), " @ ", binding, " conflicts with ", conflicts);
            } else {
                log.debug("For path ", path, ", static binding ", statik, " supersedes conflicting bindings ", conflicts);
                this.pathCache.put(path, statik);
            }
        } else {
            log.debug("Wiring path ", path, " to ", binding.getBeanType().getName(), " @ ", binding);
            this.pathCache.put(path, binding);
        }
    }

    protected void cachePrefix(String prefix, UrlBinding binding) {
        log.debug("Wiring prefix ", prefix, "* to ", binding.getBeanType().getName(), " @ ", binding);
        Set<UrlBinding> bindings = this.prefixCache.get(prefix);
        if (bindings == null) {
            bindings = new TreeSet<UrlBinding>(new Comparator<UrlBinding>(){

                @Override
                public int compare(UrlBinding o1, UrlBinding o2) {
                    int cmp = o1.getComponents().size() - o2.getComponents().size();
                    if (cmp == 0) {
                        cmp = o1.toString().compareTo(o2.toString());
                    }
                    return cmp;
                }
            });
            this.prefixCache.put(prefix, bindings);
        }
        bindings.add(binding);
    }

    public static UrlBinding parseUrlBinding(Class<? extends ActionBean> beanType) {
        net.sourceforge.stripes.action.UrlBinding annotation = beanType.getAnnotation(net.sourceforge.stripes.action.UrlBinding.class);
        if (annotation == null) {
            return null;
        }
        return UrlBindingFactory.parseUrlBinding(beanType, annotation.value());
    }

    /*
     * Unable to fully structure code
     */
    public static UrlBinding parseUrlBinding(Class<? extends ActionBean> beanType, String pattern) {
        if (pattern == null) {
            return null;
        }
        if (!pattern.startsWith("/")) {
            throw new ParseException(pattern, "A URL binding must begin with /");
        }
        path = null;
        components = new ArrayList<Object>();
        brace = false;
        escape = false;
        chars = pattern.toCharArray();
        buf = new StringBuilder(pattern.length());
        c = '\u0000';
        block5: for (i = 0; i < chars.length; ++i) {
            c = chars[i];
            if (escape) ** GOTO lbl-1000
            switch (c) {
                case '{': {
                    if (!brace) {
                        brace = true;
                        if (path == null) {
                            for (end = buf.length() - 1; end >= 0 && !Character.isJavaIdentifierPart(buf.charAt(end)); --end) {
                            }
                            if (end < 0) {
                                path = buf.toString();
                            } else {
                                path = buf.substring(0, ++end);
                                components.add(buf.substring(end));
                            }
                        } else {
                            components.add(buf.toString());
                        }
                        buf.setLength(0);
                        continue block5;
                    }
                    ** GOTO lbl48
                }
                case '}': {
                    if (brace) {
                        brace = false;
                        components.add(UrlBindingFactory.parseUrlBindingParameter(beanType, buf.toString()));
                        buf.setLength(0);
                        continue block5;
                    }
                    ** GOTO lbl48
                }
                case '\\': {
                    escape = true;
                    if (!brace) continue block5;
                    buf.append(c);
                    continue block5;
                }
lbl48:
                // 3 sources

                default: lbl-1000:
                // 2 sources

                {
                    buf.append(c);
                    escape = false;
                }
            }
        }
        if (escape) {
            throw new ParseException(pattern, "Expression must not end with escape character");
        }
        if (brace) {
            throw new ParseException(pattern, "Unterminated left brace ('{') in expression");
        }
        if (buf.length() > 0) {
            if (path == null) {
                path = buf.toString();
            } else if (c == '}') {
                components.add(UrlBindingFactory.parseUrlBindingParameter(beanType, buf.toString()));
            } else {
                components.add(buf.toString());
            }
        }
        return new UrlBinding(beanType, path, components);
    }

    /*
     * Unable to fully structure code
     */
    public static UrlBindingParameter parseUrlBindingParameter(Class<? extends ActionBean> beanClass, String string) {
        chars = string.toCharArray();
        c = '\u0000';
        escape = false;
        name = new StringBuilder();
        defaultValue = new StringBuilder();
        current = name;
        block4: for (i = 0; i < chars.length; ++i) {
            c = chars[i];
            if (escape) ** GOTO lbl-1000
            switch (c) {
                case '\\': {
                    escape = true;
                    continue block4;
                }
                case '=': {
                    current = defaultValue;
                    continue block4;
                }
                default: lbl-1000:
                // 2 sources

                {
                    current.append(c);
                    escape = false;
                }
            }
        }
        if (name.length() < 1) {
            throw new ParseException(string, "Empty parameter name in URL binding for " + beanClass.getName());
        }
        v0 = dflt = defaultValue.length() < 1 ? null : defaultValue.toString();
        if (dflt != null && "$event".equals(name.toString())) {
            throw new ParseException(string, "In ActionBean class " + beanClass.getName() + ", the " + "$event" + " parameter may not be assigned a default value. Its default value is" + " determined by the @DefaultHandler annotation.");
        }
        return new UrlBindingParameter((Class)beanClass, name.toString(), null, dflt){

            public String getValue() {
                throw new UnsupportedOperationException("getValue() is not implemented for URL parameter prototypes");
            }
        };
    }

    @Deprecated
    protected String trimContextPath(HttpServletRequest request) {
        String uri = request.getRequestURI();
        String contextPath = request.getContextPath();
        if (contextPath.length() > 1) {
            uri = uri.substring(contextPath.length());
        }
        try {
            String encoding = request.getCharacterEncoding();
            uri = URLDecoder.decode(uri, encoding != null ? encoding : "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new StripesRuntimeException(e);
        }
        return uri;
    }

    public String toString() {
        return String.valueOf(this.classCache);
    }
}

