/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.controller;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.controller.FlashRequest;
import net.sourceforge.stripes.controller.FlashResponseInvocationHandler;
import net.sourceforge.stripes.controller.StripesFilter;
import net.sourceforge.stripes.controller.StripesRequestWrapper;
import net.sourceforge.stripes.exception.StripesRuntimeException;
import net.sourceforge.stripes.util.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlashScope
extends HashMap<String, Object> {
    private static final long serialVersionUID = 1L;
    public static final int DEFAULT_TIMEOUT_IN_SECONDS = 120;
    private static final Log log = Log.getInstance(FlashScope.class);
    private static final Random random = new Random();
    private long startTime;
    private int timeout = 120;
    private HttpServletRequest request;
    private Integer key;
    private Semaphore semaphore;

    protected FlashScope(HttpServletRequest request, Integer key) {
        this.request = request;
        this.key = key;
        this.semaphore = new Semaphore(1);
        this.semaphore.acquireUninterruptibly();
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public Integer key() {
        return this.key;
    }

    protected Semaphore getSemaphore() {
        return this.semaphore;
    }

    @Deprecated
    public void requestComplete() {
        this.completeRequest();
    }

    public void completeRequest() {
        Map<Integer, FlashScope> scopes = FlashScope.getContainer(this.request, false);
        if (scopes != null && !scopes.isEmpty()) {
            Iterator<FlashScope> iterator = scopes.values().iterator();
            while (iterator.hasNext()) {
                if (!iterator.next().isExpired()) continue;
                iterator.remove();
            }
        }
        StripesRequestWrapper flashRequest = FlashRequest.replaceRequest(this.request);
        HttpServletResponse flashResponse = (HttpServletResponse)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{HttpServletResponse.class}, (InvocationHandler)new FlashResponseInvocationHandler());
        for (Object o : this.values()) {
            ActionBeanContext context;
            if (!(o instanceof ActionBean) || (context = ((ActionBean)o).getContext()) == null) continue;
            context.setRequest((HttpServletRequest)flashRequest);
            context.setResponse(flashResponse);
        }
        this.startTime = System.currentTimeMillis();
        this.request = null;
        this.semaphore.release();
    }

    public void beginRequest(HttpServletRequest request) {
        boolean acquired = false;
        try {
            acquired = this.getSemaphore().tryAcquire(1L, TimeUnit.SECONDS);
            if (!acquired) {
                log.error("Something is amiss! A timeout occurred while trying to copy a flash scope to a new request. Only StripesFilter should call FlashScope.completeRequest() and FlashScope.beginRequest(), and the calls must be properly synchronized. The timeout likely means that completeRequest() was never called or did not complete successfully on this flash scope.");
            }
            for (Map.Entry entry : this.entrySet()) {
                Object tmp;
                Object value = entry.getValue();
                if (value instanceof ActionBean && (tmp = ((ActionBean)value).getContext().getRequest()) != null && (tmp = StripesRequestWrapper.findStripesWrapper((ServletRequest)tmp)) != null && (tmp = (HttpServletRequest)((StripesRequestWrapper)((Object)tmp)).getRequest()) instanceof FlashRequest) {
                    ((FlashRequest)tmp).setDelegate(request);
                }
                request.setAttribute((String)entry.getKey(), value);
            }
        }
        catch (InterruptedException e) {
            throw new StripesRuntimeException(e);
        }
        finally {
            if (acquired) {
                this.getSemaphore().release();
            }
        }
    }

    public long age() {
        if (this.startTime == 0L) {
            return 0L;
        }
        return (System.currentTimeMillis() - this.startTime) / 1000L;
    }

    public boolean isExpired() {
        return this.age() > (long)this.timeout;
    }

    @Override
    public Object put(String name, Object value) {
        this.request.setAttribute(name, value);
        return super.put(name, value);
    }

    public void put(ActionBean bean) {
        String binding = StripesFilter.getConfiguration().getActionResolver().getUrlBinding(bean.getClass());
        super.put(binding, bean);
        ActionBean main = (ActionBean)this.request.getAttribute("actionBean");
        if (main != null && main.equals(bean)) {
            super.put("actionBean", bean);
        }
    }

    public static Collection<FlashScope> getAllFlashScopes(HttpServletRequest req) {
        Map<Integer, FlashScope> scopes = FlashScope.getContainer(req, false);
        if (scopes == null) {
            return Collections.emptySet();
        }
        return scopes.values();
    }

    public static FlashScope getPrevious(HttpServletRequest req) {
        String keyString = req.getParameter("__fsk");
        if (keyString == null) {
            return null;
        }
        try {
            Integer id = new Integer(keyString);
            Map<Integer, FlashScope> scopes = FlashScope.getContainer(req, false);
            return scopes == null ? null : scopes.remove(id);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FlashScope getCurrent(HttpServletRequest req, boolean create) {
        Map<Integer, FlashScope> scopes = FlashScope.getContainer(req, create);
        if (scopes == null) {
            return null;
        }
        FlashScope scope = null;
        Integer key = (Integer)req.getAttribute("__current_flash_scope");
        if (key != null) {
            scope = scopes.get(key);
        } else if (create) {
            Random random = FlashScope.random;
            synchronized (random) {
                while (scopes.containsKey(key = Integer.valueOf(FlashScope.random.nextInt()))) {
                }
                scope = new FlashScope(req, key);
                scopes.put(scope.key(), scope);
            }
            req.setAttribute("__current_flash_scope", (Object)key);
        }
        return scope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Map<Integer, FlashScope> getContainer(HttpServletRequest req, boolean create) {
        try {
            HttpSession session = req.getSession(create);
            Map<Integer, FlashScope> scopes = null;
            if (session == null || (scopes = FlashScope.getContainer(session)) != null || !create) return scopes;
            Class<FlashScope> clazz = FlashScope.class;
            synchronized (FlashScope.class) {
                scopes = FlashScope.getContainer(session);
                if (scopes != null) return scopes;
                scopes = new ConcurrentHashMap<Integer, FlashScope>();
                session.setAttribute("__flash_scopes", scopes);
                // ** MonitorExit[var4_5] (shouldn't be in output)
                return scopes;
            }
        }
        catch (IllegalStateException ise) {
            log.warn("An IllegalStateException got thrown trying to create a flash scope. ", "This happens when add something to flash scope for the first time ", "causes creation of the HttpSession, but for some other reason the ", "response is already committed!");
            return null;
        }
    }

    private static Map<Integer, FlashScope> getContainer(HttpSession session) throws IllegalStateException {
        return (Map)session.getAttribute("__flash_scopes");
    }
}

