/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.controller;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.controller.DispatcherServlet;
import net.sourceforge.stripes.controller.StripesFilter;
import net.sourceforge.stripes.exception.StripesServletException;
import net.sourceforge.stripes.util.HttpUtil;
import net.sourceforge.stripes.util.Log;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicMappingFilter
implements Filter {
    public static final String INCLUDE_BUFFER_SIZE_PARAM = "IncludeBufferSize";
    public static final String CONTEXT_KEY_STRIPES_FILTER = StripesFilter.class.getName();
    private static final String REQ_HEADER_INIT_FLAG = "X-Dynamic-Mapping-Filter-Init";
    private static int includeBufferSize = 1024;
    private static Log log = Log.getInstance(DynamicMappingFilter.class);
    private FilterConfig filterConfig;
    private ServletContext servletContext;
    private StripesFilter stripesFilter;
    private DispatcherServlet stripesDispatcher;
    private boolean stripesFilterIsInternal;
    private boolean initializing;

    public void init(final FilterConfig config) throws ServletException {
        try {
            String value = config.getInitParameter(INCLUDE_BUFFER_SIZE_PARAM);
            if (value != null) {
                includeBufferSize = Integer.valueOf(value.trim());
                log.info(this.getClass().getSimpleName(), " include buffer size is ", includeBufferSize);
            }
        }
        catch (Exception e) {
            log.warn(e, "Could not interpret '", config.getInitParameter(INCLUDE_BUFFER_SIZE_PARAM), "' as a number for init-param '", INCLUDE_BUFFER_SIZE_PARAM, "'. Using default value ", includeBufferSize, ".");
        }
        this.filterConfig = config;
        this.servletContext = config.getServletContext();
        this.stripesDispatcher = new DispatcherServlet();
        this.stripesDispatcher.init(new ServletConfig(){

            public String getInitParameter(String name) {
                return config.getInitParameter(name);
            }

            public Enumeration<?> getInitParameterNames() {
                return config.getInitParameterNames();
            }

            public ServletContext getServletContext() {
                return config.getServletContext();
            }

            public String getServletName() {
                return config.getFilterName();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        try {
            if (this.stripesDispatcher != null) {
                this.stripesDispatcher.destroy();
            }
        }
        finally {
            this.stripesDispatcher = null;
            try {
                if (this.stripesFilterIsInternal && this.stripesFilter != null) {
                    this.stripesFilter.destroy();
                }
            }
            finally {
                this.stripesFilter = null;
            }
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        final ErrorTrappingResponseWrapper wrapper = new ErrorTrappingResponseWrapper((HttpServletResponse)response);
        wrapper.setInclude(request.getAttribute("javax.servlet.include.servlet_path") != null);
        boolean fileNotFoundExceptionThrown = false;
        try {
            chain.doFilter(request, (ServletResponse)wrapper);
        }
        catch (FileNotFoundException exc) {
            fileNotFoundExceptionThrown = true;
        }
        boolean initializing = this.initializing || ((HttpServletRequest)request).getHeader(REQ_HEADER_INIT_FLAG) != null;
        Integer errorCode = wrapper.getErrorCode();
        if (!initializing && errorCode != null && errorCode == 404 || fileNotFoundExceptionThrown) {
            StripesFilter sf = this.getStripesFilter();
            if (sf == null) {
                this.initStripesFilter((HttpServletRequest)request, (HttpServletResponse)wrapper);
                sf = this.getStripesFilter();
            }
            sf.doFilter(request, response, new FilterChain(){

                public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
                    String uri = HttpUtil.getRequestedPath((HttpServletRequest)request);
                    Class<? extends ActionBean> beanType = DynamicMappingFilter.this.getStripesFilter().getInstanceConfiguration().getActionResolver().getActionBeanType(uri);
                    if (beanType == null) {
                        wrapper.proceed();
                    } else {
                        DynamicMappingFilter.this.stripesDispatcher.service(request, response);
                    }
                }
            });
        } else {
            wrapper.proceed();
        }
    }

    @Deprecated
    protected String getRequestURI(HttpServletRequest request) {
        String contextPath;
        String uri = (String)request.getAttribute("javax.servlet.include.request_uri");
        if (uri == null) {
            uri = request.getRequestURI();
        }
        if ((contextPath = request.getContextPath()).length() > 1) {
            uri = uri.substring(contextPath.length());
        }
        return uri;
    }

    protected StripesFilter getStripesFilter() {
        if (this.stripesFilter == null) {
            this.stripesFilter = (StripesFilter)this.servletContext.getAttribute(CONTEXT_KEY_STRIPES_FILTER);
            if (this.stripesFilter != null) {
                log.debug("Found StripesFilter in the servlet context.");
            }
        }
        return this.stripesFilter;
    }

    protected synchronized void initStripesFilter(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        try {
            if (this.getStripesFilter() != null) {
                return;
            }
            log.info("StripesFilter not initialized. Checking the situation in web.xml ...");
            Document document = this.parseWebXml();
            NodeList filterNodes = (NodeList)this.eval("/web-app/filter/filter-class[text()='" + StripesFilter.class.getName() + "']/..", document, XPathConstants.NODESET);
            if (filterNodes == null || filterNodes.getLength() != 1) {
                String msg = filterNodes == null || filterNodes.getLength() < 1 ? "StripesFilter is not declared in web.xml. " : "StripesFilter is declared multiple times in web.xml; refusing to use either one. ";
                log.info(msg, "Initializing with \"", this.filterConfig.getFilterName(), "\" configuration.");
                this.createStripesFilter(this.filterConfig);
            } else {
                Node filterNode = filterNodes.item(0);
                final String name = (String)this.eval("filter-name", filterNode, XPathConstants.STRING);
                log.debug("Found StripesFilter declared as ", name, " in web.xml");
                List<String> patterns = this.getFilterUrlPatterns(filterNode);
                if (patterns.isEmpty()) {
                    log.info("StripesFilter is declared but not mapped in web.xml. ", "Initializing with \"", name, "\" configuration from web.xml.");
                    final Map<String, String> parameters = this.getFilterParameters(filterNode);
                    this.createStripesFilter(new FilterConfig(){

                        public ServletContext getServletContext() {
                            return DynamicMappingFilter.this.servletContext;
                        }

                        public Enumeration<String> getInitParameterNames() {
                            return Collections.enumeration(parameters.keySet());
                        }

                        public String getInitParameter(String name2) {
                            return (String)parameters.get(name2);
                        }

                        public String getFilterName() {
                            return name;
                        }
                    });
                } else {
                    this.issueRequests(patterns, request, response);
                }
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new StripesServletException("Unhandled exception trying to force initialization of StripesFilter", e);
        }
        if (this.getStripesFilter() == null) {
            String msg = "There is no StripesFilter instance available in the servlet context, and DynamicMappingFilter was unable to initialize one. See previous log messages for more information.";
            log.error(msg);
            throw new StripesServletException(msg);
        }
    }

    protected Document parseWebXml() throws SAXException, IOException, ParserConfigurationException {
        return DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(this.servletContext.getResourceAsStream("/WEB-INF/web.xml"));
    }

    protected <T> T eval(String expression, Node source, QName returnType) throws XPathExpressionException {
        XPath xpath = XPathFactory.newInstance().newXPath();
        return (T)xpath.evaluate(expression, source, returnType);
    }

    protected List<String> getFilterUrlPatterns(Node filterNode) throws XPathExpressionException {
        int i;
        String filterName = (String)this.eval("filter-name", filterNode, XPathConstants.STRING);
        Document document = filterNode.getOwnerDocument();
        NodeList urlMappings = (NodeList)this.eval("/web-app/filter-mapping/filter-name[text()='" + filterName + "']/../url-pattern", document, XPathConstants.NODESET);
        NodeList servletMappings = (NodeList)this.eval("/web-app/filter-mapping/filter-name[text()='" + filterName + "']/../servlet-name", document, XPathConstants.NODESET);
        ArrayList<String> patterns = new ArrayList<String>();
        if (urlMappings != null && urlMappings.getLength() > 0) {
            for (i = 0; i < urlMappings.getLength(); ++i) {
                patterns.add(urlMappings.item(i).getTextContent().trim());
            }
        }
        if (servletMappings != null && servletMappings.getLength() > 0) {
            for (i = 0; i < servletMappings.getLength(); ++i) {
                String servletName = servletMappings.item(i).getTextContent().trim();
                urlMappings = (NodeList)this.eval("/web-app/servlet-mapping/servlet-name[text()='" + servletName + "']/../url-pattern", document, XPathConstants.NODESET);
                for (int j = 0; j < urlMappings.getLength(); ++j) {
                    patterns.add(urlMappings.item(j).getTextContent().trim());
                }
            }
        }
        log.debug("Filter ", filterName, " maps to ", patterns);
        return patterns;
    }

    protected Map<String, String> getFilterParameters(Node filterNode) throws XPathExpressionException {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        NodeList paramNodes = (NodeList)this.eval("init-param", filterNode, XPathConstants.NODESET);
        for (int i = 0; i < paramNodes.getLength(); ++i) {
            Node node = paramNodes.item(i);
            String key = (String)this.eval("param-name", node, XPathConstants.STRING);
            String value = (String)this.eval("param-value", node, XPathConstants.STRING);
            params.put(key, value);
        }
        return params;
    }

    protected void createStripesFilter(FilterConfig config) throws ServletException {
        StripesFilter filter = new StripesFilter();
        filter.init(config);
        this.stripesFilter = filter;
        this.stripesFilterIsInternal = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void issueRequests(List<String> patterns, HttpServletRequest request, HttpServletResponse response) {
        RequestDispatcher dispatcher;
        String uri;
        String random = "stripes-dmf-request-" + UUID.randomUUID();
        ArrayList<String> uris = new ArrayList<String>(patterns.size());
        for (String pattern : patterns) {
            String uri2 = pattern.replace("*", random);
            if (!uri2.startsWith("/")) {
                uri2 = "/" + uri2;
            }
            uris.add(uri2);
        }
        HttpServletRequestWrapper req = new HttpServletRequestWrapper(request){

            public String getMethod() {
                return "OPTIONS";
            }
        };
        HttpServletResponseWrapper rsp = new HttpServletResponseWrapper(response){

            public ServletOutputStream getOutputStream() throws IOException {
                return new ServletOutputStream(){

                    public void write(int b) throws IOException {
                    }
                };
            }

            public PrintWriter getWriter() throws IOException {
                return new PrintWriter((OutputStream)this.getOutputStream());
            }
        };
        log.info("Found StripesFilter declared and mapped in web.xml but not yet initialized.");
        Iterator iterator = uris.iterator();
        while (this.getStripesFilter() == null && iterator.hasNext()) {
            uri = (String)iterator.next();
            log.info("Try to force initialization of StripesFilter with forward to ", uri);
            try {
                this.initializing = true;
                dispatcher = this.servletContext.getRequestDispatcher(uri);
                dispatcher.forward((ServletRequest)req, (ServletResponse)rsp);
            }
            catch (Exception e) {
                log.debug(e, "Ignored exception during forward");
            }
            finally {
                this.initializing = false;
                response.reset();
            }
        }
        iterator = uris.iterator();
        while (this.getStripesFilter() == null && iterator.hasNext()) {
            uri = (String)iterator.next();
            log.info("Try to force initialization of StripesFilter with include of ", uri);
            try {
                this.initializing = true;
                dispatcher = this.servletContext.getRequestDispatcher(uri);
                dispatcher.forward((ServletRequest)req, (ServletResponse)rsp);
            }
            catch (Exception e) {
                log.debug(e, "Ignored exception during forward");
            }
            finally {
                this.initializing = false;
                response.reset();
            }
        }
        iterator = uris.iterator();
        while (this.getStripesFilter() == null && iterator.hasNext()) {
            try {
                uri = (String)iterator.next();
                log.info("Try to force initialization of StripesFilter with request to ", uri);
                this.requestRemotely(request, uri);
            }
            catch (Exception e) {
                log.debug(e, "Ignored exception during request");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestRemotely(HttpServletRequest request, String relativePath) {
        HttpURLConnection cxn = null;
        try {
            String protocol = new URL(request.getRequestURL().toString()).getProtocol();
            String file = request.getContextPath() + relativePath;
            URL url = new URL(protocol, request.getLocalAddr(), request.getLocalPort(), file);
            cxn = (HttpURLConnection)url.openConnection();
            cxn.setRequestMethod("OPTIONS");
            Enumeration headerNames = request.getHeaderNames();
            while (headerNames.hasMoreElements()) {
                String hdr = (String)headerNames.nextElement();
                cxn.setRequestProperty(hdr, request.getHeader(hdr));
            }
            cxn.setRequestProperty(REQ_HEADER_INIT_FLAG, "true");
            log.debug(cxn.getResponseCode(), " ", cxn.getResponseMessage(), " (", cxn.getContentLength(), " bytes) from ", url);
        }
        catch (Exception e) {
            log.debug(e, "Request failed trying to force initialization of StripesFilter");
        }
        finally {
            try {
                cxn.disconnect();
            }
            catch (Exception e) {}
        }
    }

    public static class ErrorTrappingResponseWrapper
    extends HttpServletResponseWrapper {
        private Integer errorCode;
        private String errorMessage;
        private boolean include;
        private PrintWriter printWriter;
        private TempBufferWriter tempBufferWriter;

        public ErrorTrappingResponseWrapper(HttpServletResponse response) {
            super(response);
        }

        public void sendError(int errorCode, String errorMessage) throws IOException {
            this.errorCode = errorCode;
            this.errorMessage = errorMessage;
        }

        public void sendError(int errorCode) throws IOException {
            this.errorCode = errorCode;
            this.errorMessage = null;
        }

        public PrintWriter getWriter() throws IOException {
            if (this.isInclude() && includeBufferSize > 0) {
                if (this.printWriter == null) {
                    this.tempBufferWriter = new TempBufferWriter(super.getWriter());
                    this.printWriter = new PrintWriter(this.tempBufferWriter);
                }
                return this.printWriter;
            }
            return super.getWriter();
        }

        public boolean isInclude() {
            return this.include;
        }

        public void setInclude(boolean include) {
            this.include = include;
        }

        public Integer getErrorCode() {
            return this.errorCode;
        }

        public void clearError() {
            this.errorCode = null;
            this.errorMessage = null;
        }

        public void proceed() throws IOException {
            if (this.tempBufferWriter != null) {
                this.tempBufferWriter.overflow();
            }
            if (this.errorCode != null) {
                if (this.errorMessage == null) {
                    super.sendError(this.errorCode.intValue());
                } else {
                    super.sendError(this.errorCode.intValue(), this.errorMessage);
                }
            }
        }
    }

    public static class TempBufferWriter
    extends Writer {
        private StringWriter buffer;
        private PrintWriter out;

        public TempBufferWriter(PrintWriter out) {
            this.out = out;
            this.buffer = new StringWriter(includeBufferSize);
        }

        public void close() throws IOException {
            this.flush();
            this.out.close();
        }

        public void flush() throws IOException {
            this.overflow();
            this.out.flush();
        }

        public void write(char[] chars, int offset, int length) throws IOException {
            if (this.buffer == null) {
                this.out.write(chars, offset, length);
            } else if (this.buffer.getBuffer().length() + length > includeBufferSize) {
                this.overflow();
                this.out.write(chars, offset, length);
            } else {
                this.buffer.write(chars, offset, length);
            }
        }

        protected void overflow() {
            if (this.buffer != null) {
                this.out.print(this.buffer.toString());
                this.buffer = null;
            }
        }
    }
}

