/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.controller;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Stack;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspFactory;
import javax.servlet.jsp.PageContext;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.config.Configuration;
import net.sourceforge.stripes.controller.DispatcherHelper;
import net.sourceforge.stripes.controller.ExecutionContext;
import net.sourceforge.stripes.controller.Interceptor;
import net.sourceforge.stripes.controller.LifecycleStage;
import net.sourceforge.stripes.controller.StripesFilter;
import net.sourceforge.stripes.exception.StripesServletException;
import net.sourceforge.stripes.util.HttpUtil;
import net.sourceforge.stripes.util.Log;
import net.sourceforge.stripes.validation.BooleanTypeConverter;
import net.sourceforge.stripes.validation.expression.ExpressionValidator;
import net.sourceforge.stripes.validation.expression.Jsp20ExpressionExecutor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DispatcherServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    public static final String RUN_CUSTOM_VALIDATION_WHEN_ERRORS = "Validation.InvokeValidateWhenErrorsExist";
    private Boolean alwaysInvokeValidate;
    private static final Log log = Log.getInstance(DispatcherServlet.class);

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        this.doOneTimeConfiguration();
        log.trace("Dispatching request to URL: ", HttpUtil.getRequestedPath(request));
        PageContext pageContext = null;
        ExecutionContext ctx = new ExecutionContext();
        try {
            Configuration config = StripesFilter.getConfiguration();
            ActionBeanContext context = config.getActionBeanContextFactory().getContextInstance(request, response);
            context.setServletContext(this.getServletContext());
            ctx.setActionBeanContext(context);
            try {
                ActionBeanContext abc = ctx.getActionBeanContext();
                if (ExpressionValidator.getExecutor() instanceof Jsp20ExpressionExecutor) {
                    pageContext = JspFactory.getDefaultFactory().getPageContext((Servlet)this, (ServletRequest)abc.getRequest(), (ServletResponse)abc.getResponse(), null, request.getSession(false) != null, abc.getResponse().getBufferSize(), true);
                    DispatcherHelper.setPageContext(pageContext);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            this.saveActionBean(request);
            Resolution resolution = this.requestInit(ctx);
            if (resolution == null && (resolution = this.resolveActionBean(ctx)) == null && (resolution = this.resolveHandler(ctx)) == null && (resolution = this.doBindingAndValidation(ctx)) == null && (resolution = this.doCustomValidation(ctx)) == null && (resolution = this.handleValidationErrors(ctx)) == null) {
                resolution = this.invokeEventHandler(ctx);
            }
            if (resolution != null) {
                this.executeResolution(ctx, resolution);
            }
        }
        catch (ServletException se) {
            throw se;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (InvocationTargetException ite) {
            if (ite.getTargetException() instanceof ServletException) {
                throw (ServletException)ite.getTargetException();
            }
            if (ite.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)ite.getTargetException();
            }
            throw new StripesServletException("ActionBean execution threw an exception.", ite.getTargetException());
        }
        catch (Exception e) {
            throw new StripesServletException("Exception encountered processing request.", e);
        }
        finally {
            if (pageContext != null) {
                JspFactory.getDefaultFactory().releasePageContext(pageContext);
                DispatcherHelper.setPageContext(null);
            }
            this.requestComplete(ctx);
            this.restoreActionBean(request);
        }
    }

    private Resolution requestInit(ExecutionContext ctx) throws Exception {
        ctx.setLifecycleStage(LifecycleStage.RequestInit);
        ctx.setInterceptors(StripesFilter.getConfiguration().getInterceptors(LifecycleStage.RequestInit));
        return ctx.wrap(new Interceptor(){

            public Resolution intercept(ExecutionContext context) throws Exception {
                return null;
            }
        });
    }

    private void requestComplete(ExecutionContext ctx) {
        ctx.setLifecycleStage(LifecycleStage.RequestComplete);
        ctx.setInterceptors(StripesFilter.getConfiguration().getInterceptors(LifecycleStage.RequestComplete));
        try {
            Resolution resolution = ctx.wrap(new Interceptor(){

                public Resolution intercept(ExecutionContext context) throws Exception {
                    return null;
                }
            });
            if (resolution != null) {
                log.warn(new Object[]{"Resolutions returned from interceptors for ", ctx.getLifecycleStage(), " are ignored because it is too late to execute them."});
            }
        }
        catch (Exception e) {
            log.error(e, new Object[0]);
        }
    }

    protected Resolution resolveActionBean(ExecutionContext ctx) throws Exception {
        return DispatcherHelper.resolveActionBean(ctx);
    }

    protected Resolution resolveHandler(ExecutionContext ctx) throws Exception {
        return DispatcherHelper.resolveHandler(ctx);
    }

    protected Resolution doBindingAndValidation(ExecutionContext ctx) throws Exception {
        return DispatcherHelper.doBindingAndValidation(ctx, true);
    }

    protected Resolution doCustomValidation(ExecutionContext ctx) throws Exception {
        return DispatcherHelper.doCustomValidation(ctx, this.alwaysInvokeValidate);
    }

    protected Resolution handleValidationErrors(ExecutionContext ctx) throws Exception {
        return DispatcherHelper.handleValidationErrors(ctx);
    }

    protected Resolution invokeEventHandler(ExecutionContext ctx) throws Exception {
        return DispatcherHelper.invokeEventHandler(ctx);
    }

    protected void executeResolution(ExecutionContext ctx, Resolution resolution) throws Exception {
        DispatcherHelper.executeResolution(ctx, resolution);
    }

    private void doOneTimeConfiguration() {
        if (this.alwaysInvokeValidate == null) {
            String callValidateWhenErrorsExist = StripesFilter.getConfiguration().getBootstrapPropertyResolver().getProperty(RUN_CUSTOM_VALIDATION_WHEN_ERRORS);
            if (callValidateWhenErrorsExist != null) {
                BooleanTypeConverter c = new BooleanTypeConverter();
                this.alwaysInvokeValidate = c.convert(callValidateWhenErrorsExist, Boolean.class, (Collection)null);
            } else {
                this.alwaysInvokeValidate = false;
            }
        }
    }

    protected Stack<ActionBean> getActionBeanStack(HttpServletRequest request, boolean create) {
        Stack stack = (Stack)request.getAttribute("__stripes_actionBeanStack");
        if (stack == null && create) {
            stack = new Stack();
            request.setAttribute("__stripes_actionBeanStack", stack);
        }
        return stack;
    }

    protected void saveActionBean(HttpServletRequest request) {
        if (request.getAttribute("actionBean") != null) {
            Stack<ActionBean> stack = this.getActionBeanStack(request, true);
            stack.push((ActionBean)request.getAttribute("actionBean"));
        }
    }

    protected void restoreActionBean(HttpServletRequest request) {
        Stack<ActionBean> stack = this.getActionBeanStack(request, false);
        if (stack != null && !stack.empty()) {
            request.setAttribute("actionBean", (Object)stack.pop());
        }
    }
}

