/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.controller;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpSession;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.controller.ParameterName;
import net.sourceforge.stripes.controller.StripesFilter;
import net.sourceforge.stripes.exception.StripesRuntimeException;
import net.sourceforge.stripes.util.Log;
import net.sourceforge.stripes.util.bean.NodeEvaluation;
import net.sourceforge.stripes.util.bean.PropertyExpressionEvaluation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@StrictBinding(defaultPolicy=StrictBinding.Policy.ALLOW)
public class BindingPolicyManager {
    private static final List<Class<?>> ILLEGAL_NODE_VALUE_TYPES = Arrays.asList(ActionBeanContext.class, Class.class, ClassLoader.class, HttpSession.class, ServletRequest.class, ServletResponse.class);
    private static final String PROPERTY_REGEX = "\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*";
    private static final Pattern PROPERTY_PATTERN = Pattern.compile("\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*");
    private static final Log log = Log.getInstance(BindingPolicyManager.class);
    private static final Map<Class<?>, BindingPolicyManager> instances = new HashMap();
    private Class<?> beanClass;
    private StrictBinding.Policy defaultPolicy;
    private Pattern allowPattern;
    private Pattern denyPattern;
    private Pattern validatePattern;

    public static BindingPolicyManager getInstance(Class<?> beanType) {
        if (instances.containsKey(beanType)) {
            return instances.get(beanType);
        }
        BindingPolicyManager instance = new BindingPolicyManager(beanType);
        instances.put(beanType, instance);
        return instance;
    }

    protected BindingPolicyManager(Class<?> beanClass) {
        try {
            log.debug(new Object[]{"Creating ", this.getClass().getName(), " for ", beanClass, " with default policy ", this.defaultPolicy});
            this.beanClass = beanClass;
            StrictBinding annotation = this.getAnnotation(beanClass);
            if (annotation != null) {
                this.defaultPolicy = annotation.defaultPolicy();
                this.allowPattern = this.globToPattern(annotation.allow());
                this.denyPattern = this.globToPattern(annotation.deny());
                this.validatePattern = this.globToPattern(this.getValidatedProperties(beanClass));
            }
        }
        catch (Exception e) {
            log.error(e, "%%% Failure instantiating ", this.getClass().getName());
            StripesRuntimeException sre = new StripesRuntimeException(e.getMessage(), e);
            sre.setStackTrace(e.getStackTrace());
            throw sre;
        }
    }

    public boolean isBindingAllowed(PropertyExpressionEvaluation eval) {
        boolean allow;
        if (this.usesIllegalNodeValueType(eval)) {
            return false;
        }
        String paramName = new ParameterName(eval.getExpression().getSource()).getStrippedName();
        boolean deny = this.denyPattern != null && this.denyPattern.matcher(paramName).matches();
        boolean bl = allow = this.allowPattern != null && this.allowPattern.matcher(paramName).matches() || this.validatePattern != null && this.validatePattern.matcher(paramName).matches();
        if (this.defaultPolicy == StrictBinding.Policy.DENY && !(allow ^ deny)) {
            return false;
        }
        return allow || !deny;
    }

    protected boolean usesIllegalNodeValueType(PropertyExpressionEvaluation eval) {
        for (NodeEvaluation node = eval.getRootNode(); node != null; node = node.getNext()) {
            Type type = node.getValueType();
            if (type instanceof ParameterizedType) {
                type = ((ParameterizedType)type).getRawType();
            }
            if (!(type instanceof Class)) continue;
            Class nodeClass = (Class)type;
            for (Class<?> protectedClass : ILLEGAL_NODE_VALUE_TYPES) {
                if (!protectedClass.isAssignableFrom(nodeClass)) continue;
                return true;
            }
        }
        return false;
    }

    protected StrictBinding getAnnotation(Class<?> beanType) {
        StrictBinding annotation;
        while ((annotation = beanType.getAnnotation(StrictBinding.class)) == null && (beanType = beanType.getSuperclass()) != null) {
        }
        if (annotation == null) {
            annotation = this.getClass().getAnnotation(StrictBinding.class);
        }
        return annotation;
    }

    protected String[] getValidatedProperties(Class<?> beanClass) {
        Set<String> properties = StripesFilter.getConfiguration().getValidationMetadataProvider().getValidationMetadata(beanClass).keySet();
        return new ArrayList<String>(properties).toArray(new String[properties.size()]);
    }

    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    public StrictBinding.Policy getDefaultPolicy() {
        return this.defaultPolicy;
    }

    protected Pattern globToPattern(String ... globArray) {
        if (globArray == null || globArray.length == 0) {
            return null;
        }
        ArrayList<String> globs = new ArrayList<String>();
        for (String glob : globArray) {
            String[] subs;
            for (String sub : subs = glob.split("(\\s*,\\s*)+")) {
                globs.add(sub);
            }
        }
        ArrayList<String> subs = new ArrayList<String>();
        StringBuilder buf = new StringBuilder();
        for (String glob : globs) {
            buf.setLength(0);
            String[] properties = glob.split("\\.");
            for (int i = 0; i < properties.length; ++i) {
                String property = properties[i];
                if ("*".equals(property)) {
                    buf.append(PROPERTY_REGEX);
                } else if ("**".equals(property)) {
                    buf.append(PROPERTY_REGEX).append("(\\.").append(PROPERTY_REGEX).append(")*");
                } else if (property.length() > 0) {
                    Matcher matcher = PROPERTY_PATTERN.matcher(property);
                    if (matcher.matches()) {
                        buf.append(property);
                    } else {
                        log.warn("Invalid property name: " + property);
                        return null;
                    }
                }
                if (i >= properties.length - 1) continue;
                buf.append("\\.");
            }
            if (buf.length() == 0) continue;
            subs.add(buf.toString());
        }
        buf.setLength(0);
        for (String sub : subs) {
            buf.append(sub).append('|');
        }
        if (buf.length() > 0) {
            buf.setLength(buf.length() - 1);
        }
        log.debug("Translated globs ", Arrays.toString(globArray), " to regex ", buf);
        if (buf.length() == 0) {
            return null;
        }
        return Pattern.compile(buf.toString());
    }
}

