/*
 * Decompiled with CFR 0.152.
 */
package kieker.examples.monitoring.aspectj;

import java.util.concurrent.CountDownLatch;
import kieker.examples.monitoring.aspectj.Bookstore;

public final class BookstoreStarter {
    private static final int NUM_REQUESTS_DEFAULT = 1;

    private BookstoreStarter() {
    }

    public static void main(String[] stringArray) throws InterruptedException {
        Bookstore bookstore = new Bookstore();
        int n = BookstoreStarter.extractNumRequestsFromArgs(stringArray);
        CountDownLatch countDownLatch = new CountDownLatch(n);
        for (int i = 0; i < n; ++i) {
            System.out.println("Bookstore.main: Starting request " + i);
            BookstoreStarter.spawnAsyncRequest(bookstore, countDownLatch);
        }
        countDownLatch.await();
    }

    private static void spawnAsyncRequest(final Bookstore bookstore, final CountDownLatch countDownLatch) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                bookstore.searchBook();
                countDownLatch.countDown();
            }
        }).start();
    }

    private static int extractNumRequestsFromArgs(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return 1;
        }
        try {
            return Integer.parseInt(stringArray[0]);
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("Couldn't extract number from argument value " + stringArray[0]);
            System.out.println("Will use the default value 1");
            return 1;
        }
    }
}

