/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.writer.filesystem;

import java.util.concurrent.BlockingQueue;
import kieker.common.configuration.Configuration;
import kieker.common.logging.Log;
import kieker.common.logging.LogFactory;
import kieker.common.record.IMonitoringRecord;
import kieker.common.util.filesystem.BinaryCompressionMethod;
import kieker.monitoring.core.controller.IMonitoringController;
import kieker.monitoring.writer.filesystem.AbstractAsyncFSWriter;
import kieker.monitoring.writer.filesystem.async.AbstractFsWriterThread;
import kieker.monitoring.writer.filesystem.async.BinaryFsWriterThread;
import kieker.monitoring.writer.filesystem.map.MappingFileWriter;

public final class AsyncBinaryFsWriter
extends AbstractAsyncFSWriter {
    private static final String PREFIX = AsyncBinaryFsWriter.class.getName() + ".";
    public static final String CONFIG_BUFFER = PREFIX + "bufferSize";
    public static final String CONFIG_COMPRESS = PREFIX + "compress";
    private static final Log LOG = LogFactory.getLog(AsyncBinaryFsWriter.class);
    private final int buffersize;
    private final BinaryCompressionMethod method;

    public AsyncBinaryFsWriter(Configuration configuration) {
        super(configuration);
        BinaryCompressionMethod tmpMethod;
        try {
            tmpMethod = BinaryCompressionMethod.valueOf(configuration.getStringProperty(CONFIG_COMPRESS));
        }
        catch (IllegalArgumentException ex) {
            LOG.warn("Failed to select compression method. Using NONE instead. " + ex.getMessage());
            tmpMethod = BinaryCompressionMethod.NONE;
        }
        this.method = tmpMethod;
        int tmpBuffersize = configuration.getIntProperty(CONFIG_BUFFER);
        if (tmpBuffersize <= 0) {
            LOG.warn("Buffer size has to be greater than zero. Using 8192 instead.");
            tmpBuffersize = 8192;
        }
        this.buffersize = tmpBuffersize;
    }

    @Override
    protected Configuration getDefaultConfiguration() {
        Configuration configuration = new Configuration(super.getDefaultConfiguration());
        configuration.setProperty(CONFIG_BUFFER, "8192");
        configuration.setProperty(CONFIG_COMPRESS, "NONE");
        return configuration;
    }

    @Override
    protected final AbstractFsWriterThread initWorker(IMonitoringController monitoringController, BlockingQueue<IMonitoringRecord> writeQueue, MappingFileWriter mappingFileWriter, String path, int maxEntiresInFile, int maxlogSize, int maxLogFiles) {
        return new BinaryFsWriterThread(monitoringController, writeQueue, mappingFileWriter, path, maxEntiresInFile, maxlogSize, maxLogFiles, this.buffersize, this.method);
    }
}

