/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.writer.database;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import kieker.common.configuration.Configuration;
import kieker.monitoring.writer.AbstractAsyncWriter;
import kieker.monitoring.writer.database.DBWriterHelper;
import kieker.monitoring.writer.database.DbWriterThread;

public final class AsyncDbWriter
extends AbstractAsyncWriter {
    private static final String PREFIX = AsyncDbWriter.class.getName() + ".";
    public static final String CONFIG_DRIVERCLASSNAME = PREFIX + "DriverClassname";
    public static final String CONFIG_CONNECTIONSTRING = PREFIX + "ConnectionString";
    public static final String CONFIG_TABLEPREFIX = PREFIX + "TablePrefix";
    public static final String CONFIG_NRCONN = PREFIX + "numberOfConnections";
    public static final String CONFIG_OVERWRITE = PREFIX + "DropTables";
    private final String connectionString;
    private final String tablePrefix;
    private final boolean overwrite;
    private final int connections;

    public AsyncDbWriter(Configuration configuration) throws Exception {
        super(configuration);
        try {
            Class.forName(configuration.getStringProperty(CONFIG_DRIVERCLASSNAME)).newInstance();
        }
        catch (Exception ex) {
            throw new Exception("DB driver registration failed. Perhaps the driver jar is missing?", ex);
        }
        this.connectionString = configuration.getStringProperty(CONFIG_CONNECTIONSTRING);
        this.tablePrefix = configuration.getStringProperty(CONFIG_TABLEPREFIX);
        this.overwrite = configuration.getBooleanProperty(CONFIG_OVERWRITE);
        this.connections = configuration.getIntProperty(CONFIG_NRCONN);
    }

    @Override
    public void init() throws Exception {
        AtomicInteger tableCounter = new AtomicInteger();
        Connection connection = null;
        try {
            connection = DriverManager.getConnection(this.connectionString);
            new DBWriterHelper(connection, this.tablePrefix, tableCounter, this.overwrite).createIndexTable();
        }
        catch (SQLException ex) {
            throw new Exception("SQLException with SQLState: '" + ex.getSQLState() + "' and VendorError: '" + ex.getErrorCode() + "'", ex);
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        AtomicLong recordId = new AtomicLong();
        try {
            for (int i = 0; i < this.connections; ++i) {
                this.addWorker(new DbWriterThread(this.monitoringController, this.blockingQueue, this.connectionString, this.tablePrefix, tableCounter, recordId, this.overwrite));
                this.addWorker(new DbWriterThread(this.monitoringController, this.prioritizedBlockingQueue, this.connectionString, this.tablePrefix, tableCounter, recordId, this.overwrite));
            }
        }
        catch (SQLException ex) {
            throw new Exception("SQLException with SQLState: '" + ex.getSQLState() + "' and VendorError: '" + ex.getErrorCode() + "'", ex);
        }
    }
}

