/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.core.controller;

import java.util.List;
import java.util.concurrent.TimeUnit;
import kieker.common.configuration.Configuration;
import kieker.common.logging.Log;
import kieker.common.logging.LogFactory;
import kieker.common.record.IMonitoringRecord;
import kieker.common.record.misc.KiekerMetadataRecord;
import kieker.common.util.Version;
import kieker.common.util.registry.IRegistry;
import kieker.monitoring.core.configuration.ConfigurationFactory;
import kieker.monitoring.core.controller.AbstractController;
import kieker.monitoring.core.controller.IMonitoringController;
import kieker.monitoring.core.controller.JMXController;
import kieker.monitoring.core.controller.ProbeController;
import kieker.monitoring.core.controller.RegistryController;
import kieker.monitoring.core.controller.SamplingController;
import kieker.monitoring.core.controller.StateController;
import kieker.monitoring.core.controller.TimeSourceController;
import kieker.monitoring.core.controller.WriterController;
import kieker.monitoring.core.sampler.ISampler;
import kieker.monitoring.core.sampler.ScheduledSamplerJob;
import kieker.monitoring.timer.ITimeSource;

public final class MonitoringController
extends AbstractController
implements IMonitoringController {
    static final Log LOG = LogFactory.getLog(MonitoringController.class);
    private final StateController stateController;
    private final SamplingController samplingController;
    private final JMXController jmxController;
    private final WriterController writerController;
    private final TimeSourceController timeSourceController;
    private final RegistryController registryController;
    private final ProbeController probeController;

    private MonitoringController(Configuration configuration) {
        super(configuration);
        this.stateController = new StateController(configuration);
        this.samplingController = new SamplingController(configuration);
        this.jmxController = new JMXController(configuration);
        this.writerController = new WriterController(configuration);
        this.timeSourceController = new TimeSourceController(configuration);
        this.registryController = new RegistryController(configuration);
        this.probeController = new ProbeController(configuration);
    }

    public static final IMonitoringController createInstance(Configuration configuration) {
        final MonitoringController monitoringController = new MonitoringController(configuration);
        monitoringController.stateController.setMonitoringController(monitoringController);
        if (monitoringController.stateController.isTerminated()) {
            monitoringController.terminate();
        }
        monitoringController.samplingController.setMonitoringController(monitoringController);
        if (monitoringController.samplingController.isTerminated()) {
            monitoringController.terminate();
        }
        monitoringController.jmxController.setMonitoringController(monitoringController);
        if (monitoringController.jmxController.isTerminated()) {
            monitoringController.terminate();
        }
        monitoringController.writerController.setMonitoringController(monitoringController);
        if (monitoringController.writerController.isTerminated()) {
            monitoringController.terminate();
        }
        monitoringController.timeSourceController.setMonitoringController(monitoringController);
        if (monitoringController.timeSourceController.isTerminated()) {
            monitoringController.terminate();
        }
        monitoringController.registryController.setMonitoringController(monitoringController);
        if (monitoringController.registryController.isTerminated()) {
            monitoringController.terminate();
        }
        monitoringController.probeController.setMonitoringController(monitoringController);
        if (monitoringController.probeController.isTerminated()) {
            monitoringController.terminate();
        }
        monitoringController.setMonitoringController(monitoringController);
        if (monitoringController.isTerminated()) {
            return monitoringController;
        }
        if (configuration.getBooleanProperty("kieker.monitoring.useShutdownHook")) {
            try {
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    @Override
                    public void run() {
                        if (!monitoringController.isMonitoringTerminated()) {
                            LOG.info("ShutdownHook notifies controller to initiate shutdown");
                            monitoringController.terminateMonitoring();
                        }
                    }
                });
            }
            catch (Exception e) {
                LOG.warn("Failed to add shutdownHook");
            }
        } else {
            LOG.warn("Shutdown Hook is disabled, loss of monitoring data might occur.");
        }
        LOG.info(monitoringController.toString());
        return monitoringController;
    }

    public static final String getVersion() {
        return Version.getVERSION();
    }

    @Override
    protected final void init() {
    }

    @Override
    protected final void cleanup() {
        LOG.info("Shutting down Monitoring Controller (" + this.getName() + ")");
        this.probeController.terminate();
        this.registryController.terminate();
        this.timeSourceController.terminate();
        this.writerController.terminate();
        this.jmxController.terminate();
        this.samplingController.terminate();
        this.stateController.terminate();
    }

    @Override
    public final String toString() {
        StringBuilder sb = new StringBuilder(2048);
        sb.append("Current State of kieker.monitoring (");
        sb.append(MonitoringController.getVersion());
        sb.append(") ");
        sb.append(this.stateController.toString());
        sb.append(this.jmxController.toString());
        sb.append(this.registryController.toString());
        sb.append(this.timeSourceController.toString());
        sb.append(this.probeController.toString());
        sb.append(this.writerController.toString());
        sb.append(this.samplingController.toString());
        return sb.toString();
    }

    @Override
    public final boolean sendMetadataAsRecord() {
        ITimeSource timesource = this.getTimeSource();
        return this.newMonitoringRecord(new KiekerMetadataRecord(null, this.getName(), this.getHostname(), this.getExperimentId(), this.isDebug(), timesource.getOffset(), timesource.getTimeUnit().name(), this.getNumberOfInserts()));
    }

    protected SamplingController getSamplingController() {
        return this.samplingController;
    }

    @Override
    public final boolean terminateMonitoring() {
        return this.stateController.terminateMonitoring();
    }

    @Override
    public final boolean isMonitoringTerminated() {
        return this.stateController.isMonitoringTerminated();
    }

    @Override
    public final boolean enableMonitoring() {
        return this.stateController.enableMonitoring();
    }

    @Override
    public final boolean disableMonitoring() {
        return this.stateController.disableMonitoring();
    }

    @Override
    public final boolean isMonitoringEnabled() {
        return this.stateController.isMonitoringEnabled();
    }

    @Override
    public final boolean isDebug() {
        return this.stateController.isDebug();
    }

    @Override
    public final String getName() {
        return this.stateController.getName();
    }

    @Override
    public final String getHostname() {
        return this.stateController.getHostname();
    }

    @Override
    public final int incExperimentId() {
        return this.stateController.incExperimentId();
    }

    @Override
    public final void setExperimentId(int newExperimentID) {
        this.stateController.setExperimentId(newExperimentID);
    }

    @Override
    public final int getExperimentId() {
        return this.stateController.getExperimentId();
    }

    @Override
    public final boolean newMonitoringRecord(IMonitoringRecord record) {
        return this.writerController.newMonitoringRecord(record);
    }

    @Override
    public final long getNumberOfInserts() {
        return this.writerController.getNumberOfInserts();
    }

    @Override
    public final ScheduledSamplerJob schedulePeriodicSampler(ISampler sampler, long initialDelay, long period, TimeUnit timeUnit) {
        return this.samplingController.schedulePeriodicSampler(sampler, initialDelay, period, timeUnit);
    }

    @Override
    public final boolean removeScheduledSampler(ScheduledSamplerJob sampler) {
        return this.samplingController.removeScheduledSampler(sampler);
    }

    @Override
    public final ITimeSource getTimeSource() {
        return this.timeSourceController.getTimeSource();
    }

    @Override
    public final String getJMXDomain() {
        return this.jmxController.getJMXDomain();
    }

    @Override
    public final int getUniqueIdForString(String string) {
        return this.registryController.getUniqueIdForString(string);
    }

    @Override
    public String getStringForUniqueId(int id) {
        return this.registryController.getStringForUniqueId(id);
    }

    @Override
    public IRegistry<String> getStringRegistry() {
        return this.registryController.getStringRegistry();
    }

    @Override
    public final boolean activateProbe(String pattern) {
        return this.probeController.activateProbe(pattern);
    }

    @Override
    public final boolean deactivateProbe(String pattern) {
        return this.probeController.deactivateProbe(pattern);
    }

    @Override
    public boolean isProbeActivated(String signature) {
        return this.probeController.isProbeActivated(signature);
    }

    @Override
    public void setProbePatternList(List<String> patternList) {
        this.probeController.setProbePatternList(patternList);
    }

    @Override
    public List<String> getProbePatternList() {
        return this.probeController.getProbePatternList();
    }

    public static final IMonitoringController getInstance() {
        return LazyHolder.INSTANCE;
    }

    private static final class LazyHolder {
        static final IMonitoringController INSTANCE = MonitoringController.createInstance(ConfigurationFactory.createSingletonConfiguration());

        private LazyHolder() {
        }
    }
}

