/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.traceAnalysis.filter.visualization.dependencyGraph;

import java.util.concurrent.TimeUnit;
import kieker.tools.traceAnalysis.filter.visualization.graph.AbstractVertexDecoration;
import kieker.tools.traceAnalysis.systemModel.Execution;

public class ResponseTimeDecoration
extends AbstractVertexDecoration {
    private final TimeUnit executionTimeunit;
    private final TimeUnit displayTimeunit;
    private final String timeUnitShortname;
    private long responseTimeSum;
    private int executionCount;
    private long minimalResponseTime = Integer.MAX_VALUE;
    private long maximalResponseTime;

    public ResponseTimeDecoration(TimeUnit executionTimeunit, TimeUnit displayTimeunit) {
        this.executionTimeunit = executionTimeunit;
        this.displayTimeunit = displayTimeunit;
        switch (displayTimeunit) {
            case NANOSECONDS: {
                this.timeUnitShortname = "ns";
                break;
            }
            case MICROSECONDS: {
                this.timeUnitShortname = "us";
                break;
            }
            case MILLISECONDS: {
                this.timeUnitShortname = "ms";
                break;
            }
            case SECONDS: {
                this.timeUnitShortname = "s";
                break;
            }
            default: {
                this.timeUnitShortname = "??";
            }
        }
    }

    public void registerExecution(Execution execution) {
        long responseTime = this.displayTimeunit.convert(execution.getTout() - execution.getTin(), this.executionTimeunit);
        this.responseTimeSum += responseTime;
        ++this.executionCount;
        if (responseTime < this.minimalResponseTime) {
            this.minimalResponseTime = responseTime;
        }
        if (responseTime > this.maximalResponseTime) {
            this.maximalResponseTime = responseTime;
        }
    }

    public long getMinimalResponseTime() {
        return this.minimalResponseTime;
    }

    public long getMaximalResponseTime() {
        return this.maximalResponseTime;
    }

    public double getAverageResponseTime() {
        return this.executionCount == 0 ? 0.0 : (double)this.responseTimeSum / (double)this.executionCount;
    }

    public long getTotalResponseTime() {
        return this.responseTimeSum;
    }

    @Override
    public String createFormattedOutput() {
        StringBuilder sb = new StringBuilder(30);
        sb.append("min: ");
        sb.append(this.getMinimalResponseTime());
        sb.append(this.timeUnitShortname);
        sb.append(", avg: ");
        sb.append(Math.round(this.getAverageResponseTime()));
        sb.append(this.timeUnitShortname);
        sb.append(", max: ");
        sb.append(this.getMaximalResponseTime());
        sb.append(this.timeUnitShortname);
        sb.append(",\\ntotal: ");
        sb.append(this.getTotalResponseTime());
        sb.append(this.timeUnitShortname);
        return sb.toString();
    }
}

