/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.traceAnalysis.filter.visualization.callTree;

import kieker.analysis.IProjectContext;
import kieker.analysis.plugin.annotation.Plugin;
import kieker.analysis.plugin.annotation.RepositoryPort;
import kieker.common.configuration.Configuration;
import kieker.tools.traceAnalysis.filter.visualization.callTree.AbstractAggregatedCallTreeFilter;
import kieker.tools.traceAnalysis.filter.visualization.callTree.AggregatedAllocationComponentOperationCallTreeNode;
import kieker.tools.traceAnalysis.filter.visualization.graph.IOriginRetentionPolicy;
import kieker.tools.traceAnalysis.filter.visualization.graph.NoOriginRetentionPolicy;
import kieker.tools.traceAnalysis.systemModel.AllocationComponent;
import kieker.tools.traceAnalysis.systemModel.Operation;
import kieker.tools.traceAnalysis.systemModel.SynchronousCallMessage;
import kieker.tools.traceAnalysis.systemModel.repository.AllocationComponentOperationPairFactory;
import kieker.tools.traceAnalysis.systemModel.repository.SystemModelRepository;
import kieker.tools.traceAnalysis.systemModel.util.AllocationComponentOperationPair;

@Plugin(description="Uses the incoming data to enrich the connected repository with data for the aggregated allocation component operation call tree", repositoryPorts={@RepositoryPort(name="systemModelRepository", repositoryType=SystemModelRepository.class)})
public class AggregatedAllocationComponentOperationCallTreeFilter
extends AbstractAggregatedCallTreeFilter<AllocationComponentOperationPair> {
    public AggregatedAllocationComponentOperationCallTreeFilter(Configuration configuration, IProjectContext projectContext) {
        super(configuration, projectContext);
    }

    @Override
    public boolean init() {
        boolean success = super.init();
        if (success) {
            super.setRoot(new AggregatedAllocationComponentOperationCallTreeNode(0, AllocationComponentOperationPairFactory.ROOT_PAIR, true, null, (IOriginRetentionPolicy)NoOriginRetentionPolicy.createInstance()));
        }
        return success;
    }

    @Override
    protected AllocationComponentOperationPair concreteCreatePair(SynchronousCallMessage callMsg) {
        AllocationComponent allocationComponent = callMsg.getReceivingExecution().getAllocationComponent();
        Operation op = callMsg.getReceivingExecution().getOperation();
        AllocationComponentOperationPair destination = this.getSystemEntityFactory().getAllocationPairFactory().getPairInstanceByPair(allocationComponent, op);
        return destination;
    }
}

