/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.traceAnalysis.filter.visualization.callTree;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicInteger;
import kieker.analysis.IProjectContext;
import kieker.analysis.plugin.annotation.Plugin;
import kieker.analysis.plugin.annotation.RepositoryPort;
import kieker.common.configuration.Configuration;
import kieker.common.util.signature.Signature;
import kieker.tools.traceAnalysis.filter.AbstractMessageTraceProcessingFilter;
import kieker.tools.traceAnalysis.filter.traceReconstruction.TraceProcessingException;
import kieker.tools.traceAnalysis.filter.visualization.callTree.AbstractCallTreeNode;
import kieker.tools.traceAnalysis.filter.visualization.callTree.WeightedDirectedCallTreeEdge;
import kieker.tools.traceAnalysis.filter.visualization.graph.NoOriginRetentionPolicy;
import kieker.tools.traceAnalysis.systemModel.AbstractMessage;
import kieker.tools.traceAnalysis.systemModel.AllocationComponent;
import kieker.tools.traceAnalysis.systemModel.AssemblyComponent;
import kieker.tools.traceAnalysis.systemModel.MessageTrace;
import kieker.tools.traceAnalysis.systemModel.Operation;
import kieker.tools.traceAnalysis.systemModel.SynchronousCallMessage;
import kieker.tools.traceAnalysis.systemModel.SynchronousReplyMessage;
import kieker.tools.traceAnalysis.systemModel.repository.SystemModelRepository;
import kieker.tools.traceAnalysis.systemModel.util.AllocationComponentOperationPair;
import kieker.tools.traceAnalysis.systemModel.util.AssemblyComponentOperationPair;

@Plugin(repositoryPorts={@RepositoryPort(name="systemModelRepository", repositoryType=SystemModelRepository.class)})
public abstract class AbstractCallTreeFilter<T>
extends AbstractMessageTraceProcessingFilter {
    private static final String ENCODING = "UTF-8";

    public AbstractCallTreeFilter(Configuration configuration, IProjectContext projectContext) {
        super(configuration, projectContext);
    }

    private static final String assemblyComponentOperationPairNodeLabel(AbstractCallTreeNode<AssemblyComponentOperationPair> node, boolean shortLabels) {
        AssemblyComponentOperationPair p = node.getEntity();
        AssemblyComponent component = p.getAssemblyComponent();
        Operation operation = p.getOperation();
        String assemblyComponentName = component.getName();
        String componentTypePackagePrefx = component.getType().getPackageName();
        String componentTypeIdentifier = component.getType().getTypeName();
        StringBuilder strBuild = new StringBuilder(assemblyComponentName).append(":");
        if (!shortLabels) {
            strBuild.append(componentTypePackagePrefx).append('.');
        } else {
            strBuild.append("..");
        }
        strBuild.append(componentTypeIdentifier).append("\\n.");
        Signature sig = operation.getSignature();
        StringBuilder opLabel = new StringBuilder(sig.getName());
        opLabel.append('(');
        String[] paramList = sig.getParamTypeList();
        if (paramList.length > 0) {
            opLabel.append("..");
        }
        opLabel.append(')');
        strBuild.append(opLabel.toString());
        return strBuild.toString();
    }

    private static final String allocationComponentOperationPairNodeLabel(AbstractCallTreeNode<AllocationComponentOperationPair> node, boolean shortLabels) {
        AllocationComponentOperationPair p = node.getEntity();
        AllocationComponent component = p.getAllocationComponent();
        Operation operation = p.getOperation();
        String resourceContainerName = component.getExecutionContainer().getName();
        String assemblyComponentName = component.getAssemblyComponent().getName();
        String componentTypePackagePrefx = component.getAssemblyComponent().getType().getPackageName();
        String componentTypeIdentifier = component.getAssemblyComponent().getType().getTypeName();
        StringBuilder strBuild = new StringBuilder(resourceContainerName).append("::\\n").append(assemblyComponentName).append(":");
        if (!shortLabels) {
            strBuild.append(componentTypePackagePrefx).append('.');
        } else {
            strBuild.append("..");
        }
        strBuild.append(componentTypeIdentifier).append("\\n.");
        Signature sig = operation.getSignature();
        StringBuilder opLabel = new StringBuilder(sig.getName());
        opLabel.append('(');
        String[] paramList = sig.getParamTypeList();
        if (paramList.length > 0) {
            opLabel.append("..");
        }
        opLabel.append(')');
        strBuild.append(opLabel.toString());
        return strBuild.toString();
    }

    protected static final String nodeLabel(AbstractCallTreeNode<?> node, boolean shortLabels) {
        if (node.getEntity() instanceof AllocationComponentOperationPair) {
            return AbstractCallTreeFilter.allocationComponentOperationPairNodeLabel(node, shortLabels);
        }
        if (node.getEntity() instanceof AssemblyComponentOperationPair) {
            return AbstractCallTreeFilter.assemblyComponentOperationPairNodeLabel(node, shortLabels);
        }
        throw new UnsupportedOperationException("Node type not supported: " + node.getEntity().getClass().getName());
    }

    private static void dotEdgesFromSubTree(AbstractCallTreeNode<?> n, Map<AbstractCallTreeNode<?>, Integer> nodeIds, AtomicInteger nextNodeId, PrintStream ps, boolean shortLabels) {
        StringBuilder strBuild = new StringBuilder(64);
        nodeIds.put(n, nextNodeId.get());
        strBuild.append(nextNodeId.getAndIncrement()).append("[label =\"").append(n.isRootNode() ? "'Entry'" : AbstractCallTreeFilter.nodeLabel(n, shortLabels)).append("\",shape=none];");
        ps.println(strBuild.toString());
        for (WeightedDirectedCallTreeEdge<?> child : n.getChildEdges()) {
            AbstractCallTreeFilter.dotEdgesFromSubTree((AbstractCallTreeNode)child.getTarget(), nodeIds, nextNodeId, ps, shortLabels);
        }
    }

    private static void dotVerticesFromSubTree(AbstractCallTreeNode<?> n, AtomicInteger eoiCounter, Map<AbstractCallTreeNode<?>, Integer> nodeIds, PrintStream ps, boolean includeWeights) {
        int thisId = nodeIds.get(n);
        for (WeightedDirectedCallTreeEdge<?> child : n.getChildEdges()) {
            StringBuilder strBuild = new StringBuilder(1024);
            int childId = nodeIds.get(child.getTarget());
            strBuild.append('\n').append(thisId).append("->").append(childId).append("[style=solid,arrowhead=none");
            if (includeWeights) {
                strBuild.append(",label=\"").append(child.getTargetWeight().get()).append('\"');
            } else if (eoiCounter != null) {
                strBuild.append(",label=\"").append(eoiCounter.getAndIncrement()).append(".\"");
            }
            strBuild.append(" ]");
            ps.println(strBuild.toString());
            AbstractCallTreeFilter.dotVerticesFromSubTree((AbstractCallTreeNode)child.getTarget(), eoiCounter, nodeIds, ps, includeWeights);
        }
    }

    private static void dotFromCallingTree(AbstractCallTreeNode<?> root, PrintStream ps, boolean includeWeights, boolean includeEois, boolean shortLabels) {
        ps.println("digraph G {");
        StringBuilder edgestringBuilder = new StringBuilder();
        Hashtable nodeIds = new Hashtable();
        AbstractCallTreeFilter.dotEdgesFromSubTree(root, nodeIds, new AtomicInteger(0), ps, shortLabels);
        AbstractCallTreeFilter.dotVerticesFromSubTree(root, includeEois ? new AtomicInteger(1) : null, nodeIds, ps, includeWeights);
        ps.println(edgestringBuilder.toString());
        ps.println("}");
    }

    protected static void saveTreeToDotFile(AbstractCallTreeNode<?> root, String outputFn, boolean includeWeights, boolean includeEois, boolean shortLabels) throws FileNotFoundException, UnsupportedEncodingException {
        PrintStream ps = new PrintStream((OutputStream)new FileOutputStream(outputFn), false, ENCODING);
        AbstractCallTreeFilter.dotFromCallingTree(root, ps, includeWeights, includeEois, shortLabels);
        ps.flush();
        ps.close();
    }

    protected static <T> void addTraceToTree(AbstractCallTreeNode<T> root, MessageTrace t, IPairFactory<T> pairFactory, boolean aggregated) throws TraceProcessingException {
        Stack<AbstractCallTreeNode<T>> curStack = new Stack<AbstractCallTreeNode<T>>();
        List<AbstractMessage> msgTraceVec = t.getSequenceAsVector();
        AbstractCallTreeNode<T> curNode = root;
        curStack.push(curNode);
        for (AbstractMessage m : msgTraceVec) {
            if (m instanceof SynchronousCallMessage) {
                AbstractCallTreeNode<T> child;
                curNode = (AbstractCallTreeNode<T>)curStack.peek();
                curNode = child = curNode.newCall(pairFactory.createPair((SynchronousCallMessage)m), t, NoOriginRetentionPolicy.createInstance());
                curStack.push(curNode);
                continue;
            }
            if (m instanceof SynchronousReplyMessage) {
                curNode = (AbstractCallTreeNode)curStack.pop();
                continue;
            }
            throw new TraceProcessingException("Message type not supported:" + m.getClass().getName());
        }
        if (curStack.pop() != root) {
            throw new TraceProcessingException("Stack not empty after processing trace");
        }
    }

    public static <T> void writeDotForMessageTrace(AbstractCallTreeNode<T> root, IPairFactory<T> pairFactory, MessageTrace msgTrace, String outputFilename, boolean includeWeights, boolean shortLabels) throws FileNotFoundException, TraceProcessingException, UnsupportedEncodingException {
        AbstractCallTreeFilter.addTraceToTree(root, msgTrace, pairFactory, false);
        AbstractCallTreeFilter.saveTreeToDotFile(root, outputFilename, includeWeights, true, shortLabels);
    }

    public static interface IPairFactory<T> {
        public T createPair(SynchronousCallMessage var1);
    }
}

