/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.logReplayer;

import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import kieker.common.logging.Log;
import kieker.common.logging.LogFactory;
import kieker.tools.AbstractCommandLineTool;
import kieker.tools.logReplayer.FilesystemLogReplayer;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public final class FilesystemLogReplayerStarter
extends AbstractCommandLineTool {
    private static final Log LOG = LogFactory.getLog(FilesystemLogReplayerStarter.class);
    private static final String CMD_OPT_NAME_MONITORING_CONFIGURATION = "monitoring.configuration";
    private static final String CMD_OPT_NAME_INPUTDIRS = "inputdirs";
    private static final String CMD_OPT_NAME_KEEPORIGINALLOGGINGTIMESTAMPS = "keep-logging-timestamps";
    private static final String CMD_OPT_NAME_REALTIME = "realtime";
    private static final String CMD_OPT_NAME_NUM_REALTIME_WORKERS = "realtime-worker-threads";
    private static final String CMD_OPT_NAME_REALTIME_ACCELERATION_FACTOR = "realtime-acceleration-factor";
    private static final String CMD_OPT_NAME_IGNORERECORDSBEFOREDATE = "ignore-records-before-date";
    private static final String CMD_OPT_NAME_IGNORERECORDSAFTERDATE = "ignore-records-after-date";
    private static final String DATE_FORMAT_PATTERN = "yyyyMMdd'-'HHmmss";
    private static final String DATE_FORMAT_PATTERN_CMD_USAGE_HELP = "yyyyMMdd'-'HHmmss".replaceAll("'", "");
    private static final String OPTION_EXAMPLE_FILE_MONITORING_PROPERTIES = File.separator + "path" + File.separator + "to" + File.separator + "monitoring.properties";
    private String monitoringConfigurationFile;
    private String[] inputDirs;
    private boolean keepOriginalLoggingTimestamps;
    private boolean realtimeMode;
    private double realtimeAccelerationFactor;
    private int numRealtimeWorkerThreads = -1;
    private long ignoreRecordsBeforeTimestamp = 0L;
    private long ignoreRecordsAfterTimestamp = Long.MAX_VALUE;

    private FilesystemLogReplayerStarter() {
        super(true);
    }

    public static void main(String[] args) {
        new FilesystemLogReplayerStarter().start(args);
    }

    @Override
    protected void addAdditionalOptions(Options options) {
        Option option = new Option("c", CMD_OPT_NAME_MONITORING_CONFIGURATION, true, "Configuration to use for the Kieker monitoring instance");
        option.setArgName(OPTION_EXAMPLE_FILE_MONITORING_PROPERTIES);
        option.setRequired(false);
        option.setValueSeparator('=');
        options.addOption(option);
        option = new Option("i", CMD_OPT_NAME_INPUTDIRS, true, "Log directories to read data from");
        option.setArgName("dir1 ... dirN");
        option.setRequired(false);
        option.setArgs(-2);
        options.addOption(option);
        option = new Option("k", CMD_OPT_NAME_KEEPORIGINALLOGGINGTIMESTAMPS, true, "Replay the original logging timestamps (defaults to true)?");
        option.setArgName("true|false");
        option.setRequired(false);
        option.setValueSeparator('=');
        options.addOption(option);
        option = new Option("r", CMD_OPT_NAME_REALTIME, true, "Replay log data in realtime?");
        option.setArgName("true|false");
        option.setRequired(false);
        option.setValueSeparator('=');
        options.addOption(option);
        option = new Option("n", CMD_OPT_NAME_NUM_REALTIME_WORKERS, true, "Number of worker threads used in realtime mode (defaults to 1).");
        option.setArgName("num");
        option.setRequired(false);
        options.addOption(option);
        option = new Option("a", CMD_OPT_NAME_REALTIME_ACCELERATION_FACTOR, true, "Factor by which to accelerate (>1.0) or slow down (<1.0) the replay in realtime mode (defaults to 1.0, i.e., no acceleration/slow down).");
        option.setArgName("factor");
        option.setRequired(false);
        option.setValueSeparator('=');
        options.addOption(option);
        option = new Option(null, CMD_OPT_NAME_IGNORERECORDSBEFOREDATE, true, "Records logged before this date (UTC timezone) are ignored (disabled by default).");
        option.setArgName(DATE_FORMAT_PATTERN_CMD_USAGE_HELP);
        option.setRequired(false);
        options.addOption(option);
        option = new Option(null, CMD_OPT_NAME_IGNORERECORDSAFTERDATE, true, "Records logged after this date (UTC timezone) are ignored (disabled by default).");
        option.setArgName(DATE_FORMAT_PATTERN_CMD_USAGE_HELP);
        option.setRequired(false);
        options.addOption(option);
    }

    @Override
    protected boolean readPropertiesFromCommandLine(CommandLine commandLine) {
        String realtimeOptValStr;
        String keepOriginalLoggingTimestampsOptValStr;
        boolean retVal = true;
        this.monitoringConfigurationFile = commandLine.getOptionValue(CMD_OPT_NAME_MONITORING_CONFIGURATION);
        this.inputDirs = commandLine.getOptionValues(CMD_OPT_NAME_INPUTDIRS);
        if (this.inputDirs == null) {
            LOG.error("No input directory configured");
            retVal = false;
        }
        if (!"true".equals(keepOriginalLoggingTimestampsOptValStr = commandLine.getOptionValue(CMD_OPT_NAME_KEEPORIGINALLOGGINGTIMESTAMPS, "true")) && !"false".equals(keepOriginalLoggingTimestampsOptValStr)) {
            LOG.error("Invalid value for option keep-logging-timestamps: '" + keepOriginalLoggingTimestampsOptValStr + "'");
            retVal = false;
        }
        this.keepOriginalLoggingTimestamps = "true".equals(keepOriginalLoggingTimestampsOptValStr);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Keeping original logging timestamps: " + (this.keepOriginalLoggingTimestamps ? "true" : "false"));
        }
        if (!"true".equals(realtimeOptValStr = commandLine.getOptionValue(CMD_OPT_NAME_REALTIME, "false")) && !"false".equals(realtimeOptValStr)) {
            LOG.error("Invalid value for option realtime: '" + realtimeOptValStr + "'");
            retVal = false;
        }
        this.realtimeMode = "true".equals(realtimeOptValStr);
        String numRealtimeWorkerThreadsStr = commandLine.getOptionValue(CMD_OPT_NAME_NUM_REALTIME_WORKERS, "1");
        try {
            this.numRealtimeWorkerThreads = Integer.parseInt(numRealtimeWorkerThreadsStr);
        }
        catch (NumberFormatException ex) {
            LOG.error("Invalid value for option realtime-worker-threads: '" + numRealtimeWorkerThreadsStr + "'");
            LOG.error("NumberFormatException: ", ex);
            retVal = false;
        }
        if (this.numRealtimeWorkerThreads < 1) {
            LOG.error("Option value for realtime-worker-threads must be >= 1; found " + this.numRealtimeWorkerThreads);
            LOG.error("Invalid specification of realtime-worker-threads:" + this.numRealtimeWorkerThreads);
            retVal = false;
        }
        String realtimeAccelerationFactorStr = commandLine.getOptionValue(CMD_OPT_NAME_REALTIME_ACCELERATION_FACTOR, "1");
        try {
            this.realtimeAccelerationFactor = Double.parseDouble(realtimeAccelerationFactorStr);
        }
        catch (NumberFormatException ex) {
            LOG.error("Invalid value for option realtime-acceleration-factor: '" + numRealtimeWorkerThreadsStr + "'");
            LOG.error("NumberFormatException: ", ex);
            retVal = false;
        }
        if (this.numRealtimeWorkerThreads <= 0) {
            LOG.error("Option value for realtime-acceleration-factor must be > 0; found " + this.realtimeAccelerationFactor);
            LOG.error("Invalid specification of realtime-acceleration-factor:" + this.realtimeAccelerationFactor);
            retVal = false;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT_PATTERN, Locale.US);
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        try {
            String ignoreRecordsBeforeTimestampString = commandLine.getOptionValue(CMD_OPT_NAME_IGNORERECORDSBEFOREDATE, null);
            String ignoreRecordsAfterTimestampString = commandLine.getOptionValue(CMD_OPT_NAME_IGNORERECORDSAFTERDATE, null);
            if (ignoreRecordsBeforeTimestampString != null) {
                Date ignoreBeforeDate = dateFormat.parse(ignoreRecordsBeforeTimestampString);
                this.ignoreRecordsBeforeTimestamp = ignoreBeforeDate.getTime() * 1000000L;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Ignoring records before " + dateFormat.format(ignoreBeforeDate) + " (" + this.ignoreRecordsBeforeTimestamp + ")");
                }
            }
            if (ignoreRecordsAfterTimestampString != null) {
                Date ignoreAfterDate = dateFormat.parse(ignoreRecordsAfterTimestampString);
                this.ignoreRecordsAfterTimestamp = ignoreAfterDate.getTime() * 1000000L;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Ignoring records after " + dateFormat.format(ignoreAfterDate) + " (" + this.ignoreRecordsAfterTimestamp + ")");
                }
            }
        }
        catch (ParseException ex) {
            String erorMsg = "Error parsing date/time string. Please use the following pattern: " + DATE_FORMAT_PATTERN_CMD_USAGE_HELP;
            LOG.error(erorMsg, ex);
            return false;
        }
        if (retVal && LOG.isDebugEnabled()) {
            LOG.debug("inputDirs: " + FilesystemLogReplayerStarter.fromStringArrayToDeliminedString(this.inputDirs, ';'));
            LOG.debug("Replaying in " + (this.realtimeMode ? "" : "non-") + "realtime mode");
            if (this.realtimeMode) {
                LOG.debug("Using " + this.numRealtimeWorkerThreads + " realtime worker thread" + (this.numRealtimeWorkerThreads > 1 ? "s" : ""));
            }
        }
        return retVal;
    }

    @Override
    protected boolean performTask() {
        FilesystemLogReplayer player;
        if (LOG.isDebugEnabled()) {
            if (this.realtimeMode) {
                LOG.debug("Replaying log data in real time");
            } else {
                LOG.debug("Replaying log data in non-real time");
            }
        }
        if ((player = new FilesystemLogReplayer(this.monitoringConfigurationFile, this.realtimeMode, this.realtimeAccelerationFactor, this.keepOriginalLoggingTimestamps, this.numRealtimeWorkerThreads, this.ignoreRecordsBeforeTimestamp, this.ignoreRecordsAfterTimestamp, this.inputDirs)).replay()) {
            return true;
        }
        LOG.error("An error occured");
        return false;
    }

    private static String fromStringArrayToDeliminedString(String[] array, char delimiter) {
        Arrays.toString(array);
        StringBuilder arTostr = new StringBuilder();
        if (array.length > 0) {
            arTostr.append(array[0]);
            for (int i = 1; i < array.length; ++i) {
                arTostr.append(delimiter);
                arTostr.append(array[i]);
            }
        }
        return arTostr.toString();
    }
}

