/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.writer;

import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import kieker.common.configuration.Configuration;
import kieker.common.logging.Log;
import kieker.common.logging.LogFactory;
import kieker.common.record.IMonitoringRecord;
import kieker.monitoring.writer.AbstractAsyncThread;
import kieker.monitoring.writer.AbstractMonitoringWriter;

public abstract class AbstractAsyncWriter
extends AbstractMonitoringWriter {
    public static final String CONFIG_QUEUESIZE = "QueueSize";
    public static final String CONFIG_PRIORITIZED_QUEUESIZE = "PrioritizedQueueSize";
    public static final String CONFIG_BEHAVIOR = "QueueFullBehavior";
    public static final String CONFIG_SHUTDOWNDELAY = "MaxShutdownDelay";
    private static final Log LOG = LogFactory.getLog(AbstractAsyncWriter.class);
    protected final BlockingQueue<IMonitoringRecord> blockingQueue;
    protected final BlockingQueue<IMonitoringRecord> prioritizedBlockingQueue;
    private final List<AbstractAsyncThread> workers = new CopyOnWriteArrayList<AbstractAsyncThread>();
    private final int queueFullBehavior;
    private final int maxShutdownDelay;
    private final AtomicLong missedRecords;

    protected AbstractAsyncWriter(Configuration configuration) {
        super(configuration);
        String prefix = this.getClass().getName() + ".";
        int queueFullBehaviorTmp = configuration.getIntProperty(prefix + CONFIG_BEHAVIOR);
        if (queueFullBehaviorTmp < 0 || queueFullBehaviorTmp > 2) {
            LOG.warn("Unknown value '" + queueFullBehaviorTmp + "' for " + prefix + CONFIG_BEHAVIOR + "; using default value 0");
            this.queueFullBehavior = 0;
        } else {
            this.queueFullBehavior = queueFullBehaviorTmp;
        }
        this.missedRecords = new AtomicLong(0L);
        this.blockingQueue = new ArrayBlockingQueue<IMonitoringRecord>(configuration.getIntProperty(prefix + CONFIG_QUEUESIZE));
        this.prioritizedBlockingQueue = new ArrayBlockingQueue<IMonitoringRecord>(configuration.getIntProperty(prefix + CONFIG_PRIORITIZED_QUEUESIZE));
        this.maxShutdownDelay = configuration.getIntProperty(prefix + CONFIG_SHUTDOWNDELAY);
    }

    @Override
    protected Configuration getDefaultConfiguration() {
        Configuration configuration = new Configuration(super.getDefaultConfiguration());
        String prefix = this.getClass().getName() + ".";
        configuration.setProperty(prefix + CONFIG_QUEUESIZE, "10000");
        configuration.setProperty(prefix + CONFIG_PRIORITIZED_QUEUESIZE, "100");
        configuration.setProperty(prefix + CONFIG_BEHAVIOR, "0");
        configuration.setProperty(prefix + CONFIG_SHUTDOWNDELAY, "-1");
        return configuration;
    }

    protected final void addWorker(AbstractAsyncThread worker) {
        this.workers.add(worker);
        worker.setDaemon(true);
        worker.start();
    }

    @Override
    public final void terminate() {
        CountDownLatch cdl = new CountDownLatch(this.workers.size());
        for (AbstractAsyncThread worker : this.workers) {
            worker.initShutdown(cdl);
        }
        boolean finished = false;
        try {
            if (this.maxShutdownDelay > -1) {
                LOG.info("Shutting down writers, waiting at most " + this.maxShutdownDelay + " milliseconds.");
                finished = cdl.await(this.maxShutdownDelay, TimeUnit.MILLISECONDS);
            } else {
                LOG.info("Shutting down writers.");
                cdl.await();
                finished = true;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (finished) {
            LOG.info("Writer shutdown complete.");
        } else {
            LOG.info("Writer shutdown incomplete, " + cdl.getCount() + " worker(s) halted.");
        }
    }

    @Override
    public final boolean newMonitoringRecord(IMonitoringRecord monitoringRecord) {
        try {
            switch (this.queueFullBehavior) {
                case 1: {
                    for (int i = 0; i < 10; ++i) {
                        try {
                            this.blockingQueue.put(monitoringRecord);
                            return true;
                        }
                        catch (InterruptedException ignore) {
                            LOG.warn("Interupted when adding new monitoring record to queue. Try: " + i);
                            Thread.currentThread().interrupt();
                            continue;
                        }
                    }
                    LOG.error("Failed to add new monitoring record to queue (Finally interruped while blocked).");
                    return false;
                }
                case 2: {
                    long tmpMissedRecords;
                    if (!this.blockingQueue.offer(monitoringRecord) && (tmpMissedRecords = this.missedRecords.getAndIncrement()) % 1024L == 0L) {
                        LOG.warn("Queue is full, dropping records. Number of already dropped records: " + tmpMissedRecords);
                    }
                    return true;
                }
            }
            try {
                this.blockingQueue.add(monitoringRecord);
            }
            catch (IllegalStateException ex) {
                LOG.error("Failed to add new monitoring record to queue. Queue is full. Either increase 'QueueSize' or change 'QueueFullBehavior' for the configured writer.");
                return false;
            }
            return true;
        }
        catch (Exception ex) {
            LOG.error("Failed to add new monitoring record to queue.", ex);
            return false;
        }
    }

    @Override
    public final boolean newMonitoringRecordNonBlocking(final IMonitoringRecord monitoringRecord) {
        try {
            if (!this.prioritizedBlockingQueue.offer(monitoringRecord)) {
                new Thread(){

                    @Override
                    public void run() {
                        try {
                            AbstractAsyncWriter.this.prioritizedBlockingQueue.put(monitoringRecord);
                            return;
                        }
                        catch (InterruptedException ignore) {
                            Thread.currentThread().interrupt();
                            return;
                        }
                    }
                }.start();
            }
            return true;
        }
        catch (Exception ex) {
            LOG.error("Failed to add new monitoring record to queue.", ex);
            return false;
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append(super.toString());
        sb.append("\n\tRecords lost: ");
        sb.append(this.missedRecords.intValue());
        sb.append("\n\tWriter Threads (");
        sb.append(this.workers.size());
        sb.append("): ");
        for (AbstractAsyncThread worker : this.workers) {
            sb.append("\n\t\t");
            sb.append(worker.toString());
        }
        return sb.toString();
    }
}

