/*
 * Decompiled with CFR 0.152.
 */
package kieker.monitoring.core.controller;

import kieker.common.configuration.Configuration;
import kieker.common.logging.Log;
import kieker.common.logging.LogFactory;
import kieker.common.util.registry.IRegistry;
import kieker.common.util.registry.Registry;
import kieker.monitoring.core.controller.AbstractController;
import kieker.monitoring.core.controller.IRegistryController;

public final class RegistryController
extends AbstractController
implements IRegistryController {
    private static final Log LOG = LogFactory.getLog(RegistryController.class);
    private final IRegistry<String> stringRegistry = new Registry<String>();

    protected RegistryController(Configuration configuration) {
        super(configuration);
    }

    @Override
    protected final void init() {
        this.stringRegistry.setRecordReceiver(this.monitoringController);
    }

    @Override
    protected final void cleanup() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Shutting down Registry Controller");
        }
    }

    @Override
    public final String toString() {
        StringBuilder sb = new StringBuilder(48);
        sb.append("RegistryController: ");
        sb.append(this.stringRegistry.getSize());
        sb.append(" strings registered.\n");
        return sb.toString();
    }

    @Override
    public final int getUniqueIdForString(String string) {
        return this.stringRegistry.get(string);
    }

    @Override
    public String getStringForUniqueId(int id) {
        return this.stringRegistry.get(id);
    }

    @Override
    public IRegistry<String> getStringRegistry() {
        return this.stringRegistry;
    }
}

