/*
 * Decompiled with CFR 0.152.
 */
package kieker.analysis.plugin.reader.filesystem;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kieker.analysis.plugin.reader.filesystem.FSReader;
import kieker.analysis.plugin.reader.filesystem.IMonitoringRecordReceiver;
import kieker.common.exception.MonitoringRecordException;
import kieker.common.logging.Log;
import kieker.common.logging.LogFactory;
import kieker.common.record.AbstractMonitoringRecord;
import kieker.common.record.IMonitoringRecord;
import kieker.common.record.controlflow.OperationExecutionRecord;
import kieker.common.util.filesystem.FSUtil;

public final class FSZipReader
implements Runnable {
    private static final Log LOG = LogFactory.getLog(FSZipReader.class);
    private final File zipFile;
    private final IMonitoringRecordReceiver recordReceiver;
    private final boolean ignoreUnknownRecordTypes;
    private final Map<Integer, String> stringRegistry = new HashMap<Integer, String>();
    private boolean terminated;
    private final Set<String> unknownTypesObserved = new HashSet<String>();

    public FSZipReader(File zipFile, IMonitoringRecordReceiver recordReceiver, boolean ignoreUnknownRecordTypes) {
        if (zipFile == null || !zipFile.isFile() || !zipFile.getName().endsWith(".zip")) {
            throw new IllegalArgumentException("Invalid zip file");
        }
        this.zipFile = zipFile;
        this.recordReceiver = recordReceiver;
        this.ignoreUnknownRecordTypes = ignoreUnknownRecordTypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        ZipInputStream zipInputStream = null;
        try {
            ZipEntry zipEntry;
            zipInputStream = new ZipInputStream(new FileInputStream(this.zipFile));
            while (null != (zipEntry = zipInputStream.getNextEntry()) && !zipEntry.getName().equals("kieker.map")) {
            }
            if (null == zipEntry) {
                LOG.error("The zip file does not contain a Kieker log: " + this.zipFile.toString());
                this.recordReceiver.newMonitoringRecord(FSReader.EOF);
                return;
            }
            this.readMappingFile(zipInputStream);
        }
        catch (IOException ex) {
            LOG.error("Error accessing ZipInputStream", ex);
            this.recordReceiver.newMonitoringRecord(FSReader.EOF);
            return;
        }
        finally {
            if (null != zipInputStream) {
                try {
                    zipInputStream.close();
                }
                catch (IOException ex) {
                    LOG.error("Failed to close ZipInputStream", ex);
                }
            }
        }
        BufferedReader reader = null;
        FilterInputStream input = null;
        try {
            ZipEntry zipEntry;
            zipInputStream = new ZipInputStream(new FileInputStream(this.zipFile));
            reader = new BufferedReader(new InputStreamReader((InputStream)zipInputStream, "UTF-8"));
            input = new DataInputStream(new BufferedInputStream(zipInputStream, 0x100000));
            while (null != (zipEntry = zipInputStream.getNextEntry())) {
                if (this.terminated) {
                    LOG.info("Shutting down DirectoryReader.");
                    break;
                }
                String filename = zipEntry.getName();
                if (!filename.startsWith("kieker")) continue;
                if (filename.endsWith(".dat")) {
                    LOG.info("< Loading " + filename);
                    this.readAsciiFile(reader);
                    continue;
                }
                if (!filename.endsWith(".bin")) continue;
                LOG.info("< Loading " + filename);
                if (this.ignoreUnknownRecordTypes) {
                    LOG.warn("The property 'ignoreUnknownRecordTypes' is not supported for binary files. But trying to read '" + filename + "'");
                }
                this.readBinaryFile((DataInputStream)input);
            }
        }
        catch (IOException ex) {
            LOG.error("Error accessing ZipInputStream", ex);
            this.recordReceiver.newMonitoringRecord(FSReader.EOF);
            return;
        }
        finally {
            try {
                zipInputStream.close();
            }
            catch (IOException ex) {
                LOG.error("Failed to close ZipInputStream", ex);
            }
            try {
                if (null != reader) {
                    reader.close();
                }
            }
            catch (IOException ex) {
                LOG.error("Failed to close ZipInputStream", ex);
            }
            try {
                if (null != input) {
                    input.close();
                }
            }
            catch (IOException ex) {
                LOG.error("Failed to close ZipInputStream", ex);
            }
        }
        this.recordReceiver.newMonitoringRecord(FSReader.EOF);
    }

    private final void readBinaryFile(DataInputStream input) {
        block17: {
            try {
                IMonitoringRecord record;
                do {
                    Integer id;
                    try {
                        id = input.readInt();
                    }
                    catch (EOFException eof) {
                        break block17;
                    }
                    String classname = this.stringRegistry.get(id);
                    if (classname == null) {
                        LOG.error("Missing classname mapping for record type id '" + id + "'");
                        break block17;
                    }
                    Class<? extends IMonitoringRecord> clazz = AbstractMonitoringRecord.classForName(classname);
                    Class<?>[] typeArray = AbstractMonitoringRecord.typesForClass(clazz);
                    long loggingTimestamp = input.readLong();
                    Object[] objectArray = new Object[typeArray.length];
                    int idx = -1;
                    for (Class<?> type : typeArray) {
                        ++idx;
                        if (type == String.class) {
                            Integer strId = input.readInt();
                            String str = this.stringRegistry.get(strId);
                            if (str == null) {
                                LOG.error("No String mapping found for id " + strId.toString());
                                objectArray[idx] = "";
                                continue;
                            }
                            objectArray[idx] = str;
                            continue;
                        }
                        if (type == Integer.TYPE || type == Integer.class) {
                            objectArray[idx] = input.readInt();
                            continue;
                        }
                        if (type == Long.TYPE || type == Long.class) {
                            objectArray[idx] = input.readLong();
                            continue;
                        }
                        if (type == Float.TYPE || type == Float.class) {
                            objectArray[idx] = Float.valueOf(input.readFloat());
                            continue;
                        }
                        if (type == Double.TYPE || type == Double.class) {
                            objectArray[idx] = input.readDouble();
                            continue;
                        }
                        if (type == Byte.TYPE || type == Byte.class) {
                            objectArray[idx] = input.readByte();
                            continue;
                        }
                        if (type == Short.TYPE || type == Short.class) {
                            objectArray[idx] = input.readShort();
                            continue;
                        }
                        if (type == Boolean.TYPE || type == Boolean.class) {
                            objectArray[idx] = input.readBoolean();
                            continue;
                        }
                        if (input.readByte() != 0) {
                            LOG.error("Unexpected value for unsupported type: " + clazz.getName());
                            return;
                        }
                        LOG.warn("Unsupported type: " + clazz.getName());
                        objectArray[idx] = null;
                    }
                    record = AbstractMonitoringRecord.createFromArray(clazz, objectArray);
                    record.setLoggingTimestamp(loggingTimestamp);
                } while (this.recordReceiver.newMonitoringRecord(record));
                this.terminated = true;
            }
            catch (Exception ex) {
                LOG.error("Error reading " + this.zipFile.toString(), ex);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void readAsciiFile(BufferedReader reader) {
        boolean abortDueToUnknownRecordType = false;
        try {
            block14: {
                String line;
                while ((line = reader.readLine()) != null) {
                    IMonitoringRecord record;
                    block13: {
                        if ((line = line.trim()).length() == 0) continue;
                        record = null;
                        String[] recordFields = line.split(";");
                        try {
                            if (recordFields[0].charAt(0) == '$') {
                                if (recordFields.length < 2) {
                                    LOG.error("Illegal record format: " + line);
                                    continue;
                                }
                                Integer id = Integer.valueOf(recordFields[0].substring(1));
                                String classname = this.stringRegistry.get(id);
                                if (classname == null) {
                                    LOG.error("Missing classname mapping for record type id '" + id + "'");
                                    continue;
                                }
                                Class<? extends IMonitoringRecord> clazz = null;
                                try {
                                    clazz = AbstractMonitoringRecord.classForName(classname);
                                }
                                catch (MonitoringRecordException ex) {
                                    if (!this.ignoreUnknownRecordTypes) {
                                        abortDueToUnknownRecordType = true;
                                        throw new MonitoringRecordException("Failed to load record type " + classname, ex);
                                    }
                                    if (this.unknownTypesObserved.contains(classname)) continue;
                                    LOG.error("Failed to load record type " + classname, ex);
                                    this.unknownTypesObserved.add(classname);
                                    continue;
                                }
                                long loggingTimestamp = Long.parseLong(recordFields[1]);
                                int skipValues = recordFields.length == 11 && clazz.equals(OperationExecutionRecord.class) ? 3 : 2;
                                record = AbstractMonitoringRecord.createFromStringArray(clazz, Arrays.copyOfRange(recordFields, skipValues, recordFields.length));
                                record.setLoggingTimestamp(loggingTimestamp);
                                break block13;
                            }
                            String[] recordFieldsReduced = new String[recordFields.length - 1];
                            System.arraycopy(recordFields, 1, recordFieldsReduced, 0, recordFields.length - 1);
                            record = AbstractMonitoringRecord.createFromStringArray(OperationExecutionRecord.class, recordFieldsReduced);
                        }
                        catch (MonitoringRecordException ex) {
                            if (abortDueToUnknownRecordType) {
                                this.terminated = true;
                                IOException newEx = new IOException("Error processing line: " + line);
                                newEx.initCause(ex);
                                throw newEx;
                            }
                            LOG.warn("Error processing line: " + line, ex);
                            continue;
                        }
                    }
                    if (this.recordReceiver.newMonitoringRecord(record)) {
                        continue;
                    }
                    break block14;
                }
                return;
            }
            this.terminated = true;
            return;
        }
        catch (Exception ex) {
            LOG.error("Error reading " + this.zipFile.toString(), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void readMappingFile(ZipInputStream zipInputStream) throws IOException {
        BufferedReader in = null;
        try {
            String line;
            in = new BufferedReader(new InputStreamReader((InputStream)zipInputStream, "UTF-8"));
            while ((line = in.readLine()) != null) {
                Integer id;
                if (line.length() == 0) continue;
                int split = line.indexOf(61);
                if (split == -1) {
                    LOG.error("Failed to parse line: {" + line + "} from mapping file in zip file " + this.zipFile.toString() + ". Each line must contain ID=VALUE pairs.");
                    continue;
                }
                String key = line.substring(0, split);
                String value = FSUtil.decodeNewline(line.substring(split + 1));
                try {
                    id = Integer.valueOf(key.charAt(0) == '$' ? key.substring(1) : key);
                }
                catch (NumberFormatException ex) {
                    LOG.error("Error reading mapping file, id must be integer", ex);
                    continue;
                }
                String prevVal = this.stringRegistry.put(id, value);
                if (prevVal == null) continue;
                LOG.error("Found addional entry for id='" + id + "', old value was '" + prevVal + "' new value is '" + value + "'");
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }
}

