/*
 * Decompiled with CFR 0.152.
 */
package kieker.examples.userguide.ch5bookstore;

import java.util.Random;
import kieker.analysis.IProjectContext;
import kieker.analysis.plugin.annotation.InputPort;
import kieker.analysis.plugin.annotation.Plugin;
import kieker.analysis.plugin.filter.AbstractFilterPlugin;
import kieker.common.configuration.Configuration;
import kieker.common.record.IMonitoringRecord;
import kieker.common.record.controlflow.OperationExecutionRecord;
import kieker.common.util.signature.ClassOperationSignaturePair;
import kieker.examples.userguide.ch5bookstore.Bookstore;
import kieker.examples.userguide.ch5bookstore.CRM;
import kieker.examples.userguide.ch5bookstore.Catalog;
import kieker.monitoring.core.controller.IMonitoringController;
import kieker.monitoring.core.controller.MonitoringController;

@Plugin
class HostNameRewriterPlugin
extends AbstractFilterPlugin {
    public static final String INPUT_PORT_NAME = "newEvent";
    private static final IMonitoringController MONITORING_CTRL = MonitoringController.getInstance();
    private static final String BOOKSTORE_HOSTNAME = "SRV0";
    private static final Random RANDOM = new Random();
    private static final int RND_PERCENTILE_HOST_IDX_1 = 34;
    private static final String[] CATALOG_HOSTNAMES = new String[]{"SRV0", "SRV1"};
    private static final String CRM_HOSTNAME = "SRV0";

    public HostNameRewriterPlugin(Configuration configuration, IProjectContext iProjectContext) {
        super(configuration, iProjectContext);
    }

    @InputPort(name="newEvent", eventTypes={IMonitoringRecord.class})
    public void newEvent(Object object) {
        if (!(object instanceof OperationExecutionRecord)) {
            return;
        }
        OperationExecutionRecord operationExecutionRecord = (OperationExecutionRecord)object;
        ClassOperationSignaturePair classOperationSignaturePair = ClassOperationSignaturePair.splitOperationSignatureStr((String)operationExecutionRecord.getOperationSignature());
        String string = operationExecutionRecord.getHostname();
        if (classOperationSignaturePair.getFqClassname().equals(Bookstore.class.getName())) {
            string = "SRV0";
        } else if (classOperationSignaturePair.getFqClassname().equals(CRM.class.getName())) {
            string = "SRV0";
        } else if (classOperationSignaturePair.getFqClassname().equals(Catalog.class.getName())) {
            string = RANDOM.nextInt(99) < 34 ? CATALOG_HOSTNAMES[0] : CATALOG_HOSTNAMES[1];
        }
        OperationExecutionRecord operationExecutionRecord2 = new OperationExecutionRecord(operationExecutionRecord.getOperationSignature(), operationExecutionRecord.getSessionId(), operationExecutionRecord.getTraceId(), operationExecutionRecord.getTin(), operationExecutionRecord.getTout(), string, operationExecutionRecord.getEoi(), operationExecutionRecord.getEss());
        MONITORING_CTRL.newMonitoringRecord((IMonitoringRecord)operationExecutionRecord2);
    }

    public Configuration getCurrentConfiguration() {
        return new Configuration();
    }
}

