/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.traceAnalysis.systemModel;

import java.util.Collections;
import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeSet;
import kieker.tools.traceAnalysis.systemModel.AbstractTrace;

public abstract class AbstractSession<T extends AbstractTrace> {
    private final SortedSet<T> containedTraces;
    private final String sessionId;
    private volatile long startTime = Long.MAX_VALUE;
    private volatile long endTime = Long.MIN_VALUE;
    private volatile ISessionState<T> state = new ModifiableState();

    public AbstractSession(String sessionId) {
        this.sessionId = sessionId;
        this.containedTraces = new TreeSet<T>(this.getOrderComparator());
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void addTrace(T trace) {
        this.state.addTrace(trace);
    }

    public SortedSet<T> getContainedTraces() {
        return this.state.getContainedTraces();
    }

    public long getStartTimestamp() {
        return this.state.getStartTimestamp();
    }

    public long getEndTimestamp() {
        return this.state.getEndTimestamp();
    }

    public void setCompleted() {
        this.state.setCompleted();
    }

    protected abstract Comparator<? super T> getOrderComparator();

    private class UnmodifiableState
    implements ISessionState<T> {
        @Override
        public void addTrace(T trace) {
        }

        @Override
        public SortedSet<T> getContainedTraces() {
            return Collections.unmodifiableSortedSet(AbstractSession.this.containedTraces);
        }

        @Override
        public long getStartTimestamp() {
            if (AbstractSession.this.containedTraces.isEmpty()) {
                return 0L;
            }
            return AbstractSession.this.startTime;
        }

        @Override
        public long getEndTimestamp() {
            if (AbstractSession.this.containedTraces.isEmpty()) {
                return 0L;
            }
            return AbstractSession.this.endTime;
        }

        @Override
        public void setCompleted() {
        }
    }

    private class ModifiableState
    implements ISessionState<T> {
        @Override
        public synchronized void addTrace(T trace) {
            if (!AbstractSession.this.containedTraces.add(trace)) {
                return;
            }
            if (((AbstractTrace)trace).getStartTimestamp() < AbstractSession.this.startTime) {
                AbstractSession.this.startTime = ((AbstractTrace)trace).getStartTimestamp();
            }
            if (((AbstractTrace)trace).getEndTimestamp() > AbstractSession.this.endTime) {
                AbstractSession.this.endTime = ((AbstractTrace)trace).getEndTimestamp();
            }
        }

        @Override
        public synchronized SortedSet<T> getContainedTraces() {
            return Collections.unmodifiableSortedSet(AbstractSession.this.containedTraces);
        }

        @Override
        public synchronized long getStartTimestamp() {
            if (AbstractSession.this.containedTraces.isEmpty()) {
                return 0L;
            }
            return AbstractSession.this.startTime;
        }

        @Override
        public synchronized long getEndTimestamp() {
            if (AbstractSession.this.containedTraces.isEmpty()) {
                return 0L;
            }
            return AbstractSession.this.endTime;
        }

        @Override
        public synchronized void setCompleted() {
            AbstractSession.this.state = new UnmodifiableState();
        }
    }

    private static interface ISessionState<T extends AbstractTrace> {
        public void addTrace(T var1);

        public SortedSet<T> getContainedTraces();

        public long getStartTimestamp();

        public long getEndTimestamp();

        public void setCompleted();
    }
}

