/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.traceAnalysis.filter.sessionReconstruction;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import kieker.analysis.IProjectContext;
import kieker.analysis.plugin.annotation.InputPort;
import kieker.analysis.plugin.annotation.OutputPort;
import kieker.analysis.plugin.annotation.Plugin;
import kieker.analysis.plugin.annotation.Property;
import kieker.analysis.plugin.filter.AbstractFilterPlugin;
import kieker.common.configuration.Configuration;
import kieker.tools.traceAnalysis.systemModel.AbstractSession;
import kieker.tools.traceAnalysis.systemModel.ExecutionTrace;
import kieker.tools.traceAnalysis.systemModel.ExecutionTraceBasedSession;

@Plugin(description="Reconstructs sessions from execution or message traces", outputPorts={@OutputPort(name="executionTraceSessions", description="Reconstructed execution trace-based sessions", eventTypes={ExecutionTraceBasedSession.class})}, configuration={@Property(name="maxThinkTime", defaultValue="500000"), @Property(name="timeunit", defaultValue="NANOSECONDS")})
public class SessionReconstructionFilter
extends AbstractFilterPlugin {
    public static final String INPUT_PORT_NAME_EXECUTION_TRACES = "executionTraces";
    public static final String OUTPUT_PORT_NAME_EXECUTION_TRACE_SESSIONS = "executionTraceSessions";
    public static final String CONFIG_PROPERTY_NAME_TIMEUNIT = "timeunit";
    public static final String CONFIG_PROPERTY_VALUE_TIMEUNIT = "NANOSECONDS";
    public static final String CONFIG_PROPERTY_NAME_MAX_THINK_TIME = "maxThinkTime";
    public static final String CONFIG_PROPERTY_VALUE_MAX_THINK_TIME = "9223372036854775807";
    private static final int DEFAULT_QUEUE_SIZE = 16;
    private final TimeUnit timeunit;
    private final long maxThinkTime;
    private final ConcurrentHashMap<String, ExecutionTraceBasedSession> openExecutionBasedSessions = new ConcurrentHashMap();
    private final PriorityQueue<ExecutionTraceBasedSession> executionSessionTimeoutQueue = new PriorityQueue(16, new SessionEndTimestampComparator());

    public SessionReconstructionFilter(Configuration configuration, IProjectContext projectContext) {
        super(configuration, projectContext);
        TimeUnit configTimeunit;
        this.timeunit = this.recordsTimeUnitFromProjectContext;
        String configTimeunitProperty = configuration.getStringProperty(CONFIG_PROPERTY_NAME_TIMEUNIT);
        try {
            configTimeunit = TimeUnit.valueOf(configTimeunitProperty);
        }
        catch (IllegalArgumentException ex) {
            this.log.warn(configTimeunitProperty + " is no valid TimeUnit! Using inherited value of " + this.timeunit.name() + " instead.");
            configTimeunit = this.timeunit;
        }
        this.maxThinkTime = this.timeunit.convert(configuration.getLongProperty(CONFIG_PROPERTY_NAME_MAX_THINK_TIME), configTimeunit);
        if (this.maxThinkTime < 0L) {
            throw new IllegalArgumentException("value 9223372036854775807 must not be negative (found: " + this.maxThinkTime + ")");
        }
    }

    @Override
    public Configuration getCurrentConfiguration() {
        Configuration configuration = new Configuration();
        configuration.setProperty(CONFIG_PROPERTY_NAME_TIMEUNIT, this.timeunit.name());
        configuration.setProperty(CONFIG_PROPERTY_NAME_MAX_THINK_TIME, Long.toString(this.maxThinkTime));
        return configuration;
    }

    private <T extends AbstractSession<?>> void dispatchCompletedSession(T session, String outputPortName) {
        session.setCompleted();
        this.deliver(outputPortName, session);
    }

    private <T extends AbstractSession<?>> void processTimeouts(long currentTime, String outputPortName, PriorityQueue<T> timeoutQueue, Map<String, T> openSessions) {
        AbstractSession session;
        long currentThinkTime;
        while (!timeoutQueue.isEmpty() && (currentThinkTime = currentTime - (session = (AbstractSession)timeoutQueue.peek()).getEndTimestamp()) > this.maxThinkTime) {
            timeoutQueue.remove();
            openSessions.remove(session.getSessionId());
            this.dispatchCompletedSession(session, outputPortName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends AbstractSession<?>> void closeAndDispatchAllSessions(PriorityQueue<T> timeoutQueue, Map<String, T> openSessions, String outputPortName) {
        SessionReconstructionFilter sessionReconstructionFilter = this;
        synchronized (sessionReconstructionFilter) {
            while (!timeoutQueue.isEmpty()) {
                AbstractSession session = (AbstractSession)timeoutQueue.poll();
                openSessions.remove(session.getSessionId());
                this.dispatchCompletedSession(session, outputPortName);
            }
        }
    }

    private void closeAndDispatchRemainingSessions() {
        this.closeAndDispatchAllSessions(this.executionSessionTimeoutQueue, this.openExecutionBasedSessions, OUTPUT_PORT_NAME_EXECUTION_TRACE_SESSIONS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InputPort(name="executionTraces", description="Receives execution traces", eventTypes={ExecutionTrace.class})
    public void processExecutionTrace(ExecutionTrace executionTrace) {
        SessionReconstructionFilter sessionReconstructionFilter = this;
        synchronized (sessionReconstructionFilter) {
            long currentTimestamp = executionTrace.getStartTimestamp();
            this.processTimeouts(currentTimestamp, OUTPUT_PORT_NAME_EXECUTION_TRACE_SESSIONS, this.executionSessionTimeoutQueue, this.openExecutionBasedSessions);
            boolean existingSession = true;
            String sessionId = executionTrace.getSessionId();
            ExecutionTraceBasedSession session = this.openExecutionBasedSessions.get(sessionId);
            if (session == null) {
                session = new ExecutionTraceBasedSession(sessionId);
                this.openExecutionBasedSessions.put(sessionId, session);
                existingSession = false;
            }
            session.addTrace(executionTrace);
            if (existingSession) {
                this.executionSessionTimeoutQueue.remove(session);
            }
            this.executionSessionTimeoutQueue.add(session);
        }
    }

    @Override
    public void terminate(boolean previousError) {
        if (!previousError) {
            this.closeAndDispatchRemainingSessions();
        }
    }

    private static class SessionEndTimestampComparator
    implements Comparator<AbstractSession<?>>,
    Serializable {
        private static final long serialVersionUID = -5631887288009598075L;

        @Override
        public int compare(AbstractSession<?> o1, AbstractSession<?> o2) {
            long endTimestamp2;
            long endTimestamp1 = o1.getEndTimestamp();
            if (endTimestamp1 == (endTimestamp2 = o2.getEndTimestamp())) {
                return 0;
            }
            if (endTimestamp1 < endTimestamp2) {
                return -1;
            }
            return 1;
        }
    }
}

