/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.bridge.connector;

import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kieker.common.record.IMonitoringRecord;
import kieker.tools.bridge.LookupEntity;
import kieker.tools.bridge.connector.ConnectorDataTransmissionException;

public final class ServiceConnectorFactory {
    private static final String TYPES = "TYPES";

    private ServiceConnectorFactory() {
    }

    public static ConcurrentMap<Integer, LookupEntity> createLookupEntityMap(ConcurrentMap<Integer, Class<? extends IMonitoringRecord>> recordMap) throws ConnectorDataTransmissionException {
        ConcurrentHashMap<Integer, LookupEntity> lookupEntityMap = new ConcurrentHashMap<Integer, LookupEntity>();
        Iterator i$ = recordMap.keySet().iterator();
        while (i$.hasNext()) {
            int key = (Integer)i$.next();
            Class type = (Class)recordMap.get(key);
            try {
                final Field parameterTypesField = type.getDeclaredField(TYPES);
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        parameterTypesField.setAccessible(true);
                        return null;
                    }
                });
                LookupEntity entity = new LookupEntity(type.getConstructor((Class[])parameterTypesField.get(null)), (Class[])parameterTypesField.get(null));
                lookupEntityMap.put(key, entity);
            }
            catch (NoSuchFieldException e) {
                throw new ConnectorDataTransmissionException("Field TYPES does not exist.", e);
            }
            catch (SecurityException e) {
                throw new ConnectorDataTransmissionException("Security exception.", e);
            }
            catch (NoSuchMethodException e) {
                throw new ConnectorDataTransmissionException("Method not found. Should not occur, as we are not looking for any method.", e);
            }
            catch (IllegalArgumentException e) {
                throw new ConnectorDataTransmissionException(e.getMessage(), e);
            }
            catch (IllegalAccessException e) {
                throw new ConnectorDataTransmissionException(e.getMessage(), e);
            }
        }
        return lookupEntityMap;
    }
}

