/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools.bridge;

import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import kieker.common.configuration.Configuration;
import kieker.monitoring.core.controller.IMonitoringController;
import kieker.monitoring.core.controller.MonitoringController;
import kieker.tools.bridge.IServiceListener;
import kieker.tools.bridge.connector.ConnectorDataTransmissionException;
import kieker.tools.bridge.connector.ConnectorEndOfDataException;
import kieker.tools.bridge.connector.IServiceConnector;

public class ServiceContainer {
    public static final long DEFAULT_LISTENER_UPDATE_INTERVAL = 100L;
    protected volatile boolean active;
    private final Collection<IServiceListener> listeners = new CopyOnWriteArrayList<IServiceListener>();
    private final IMonitoringController kiekerMonitoringController;
    private final IServiceConnector service;
    private volatile boolean respawn;
    private volatile long listenerUpdateInterval = 100L;

    public ServiceContainer(Configuration configuration, IServiceConnector service, boolean respawn) {
        this.kiekerMonitoringController = MonitoringController.createInstance(configuration);
        this.respawn = respawn;
        this.service = service;
    }

    public void run() throws ConnectorDataTransmissionException {
        do {
            this.updateState("Starting service container.");
            this.service.initialize();
            this.active = true;
            while (this.active) {
                try {
                    this.kiekerMonitoringController.newMonitoringRecord(this.service.deserializeNextRecord());
                    if (this.kiekerMonitoringController.getNumberOfInserts() % this.listenerUpdateInterval != 0L) continue;
                    this.updateState(this.listenerUpdateInterval + " records received.");
                }
                catch (ConnectorEndOfDataException e) {
                    this.active = false;
                }
            }
            this.updateState("Shutting service container down.");
            this.service.close();
        } while (this.respawn);
        this.kiekerMonitoringController.terminateMonitoring();
    }

    public void shutdown() throws ConnectorDataTransmissionException {
        this.active = false;
        this.respawn = false;
        this.service.close();
        this.kiekerMonitoringController.terminateMonitoring();
    }

    private void updateState(String message) {
        for (IServiceListener listener : this.listeners) {
            listener.handleEvent(this.kiekerMonitoringController.getNumberOfInserts(), message);
        }
    }

    public void addListener(IServiceListener listener) {
        this.listeners.add(listener);
    }

    public void setListenerUpdateInterval(long listenerUpdateInterval) {
        this.listenerUpdateInterval = listenerUpdateInterval;
    }

    public long getRecordCount() {
        return this.kiekerMonitoringController.getNumberOfInserts();
    }

    public boolean isRespawn() {
        return this.respawn;
    }
}

