/*
 * Decompiled with CFR 0.152.
 */
package kieker.tools;

import java.io.File;
import java.io.IOException;
import kieker.analysis.AnalysisController;
import kieker.analysis.exception.AnalysisConfigurationException;
import kieker.common.logging.Log;
import kieker.common.logging.LogFactory;
import kieker.tools.AbstractCommandLineTool;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public final class KaxRun
extends AbstractCommandLineTool {
    private static final Log LOG = LogFactory.getLog(KaxRun.class);
    private String kaxFilename;

    private KaxRun() {
        super(true);
    }

    public static void main(String[] args) {
        new KaxRun().start(args);
    }

    @Override
    protected void addAdditionalOptions(Options options) {
        Option inputOption = new Option("i", "input", true, "the analysis project file (.kax) loaded");
        inputOption.setRequired(true);
        inputOption.setArgName("filename");
        options.addOption(inputOption);
    }

    @Override
    protected boolean readPropertiesFromCommandLine(CommandLine commandLine) {
        this.kaxFilename = commandLine.getOptionValue('i');
        return true;
    }

    @Override
    protected boolean performTask() {
        boolean success = false;
        try {
            new AnalysisController(new File(this.kaxFilename)).run();
            success = true;
        }
        catch (IOException ex) {
            LOG.error("The given file could not be loaded", ex);
        }
        catch (AnalysisConfigurationException ex) {
            LOG.error("The given configuration file is invalid", ex);
        }
        catch (Exception ex) {
            LOG.error("Error", ex);
        }
        return success;
    }
}

